/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.circle_magic.rites;

import java.util.List;
import java.util.UUID;
import net.favouriteless.enchanted.common.circle_magic.rites.Rite;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CommandRite
extends Rite
implements CommandSource {
    private final List<List<String>> commands;
    private final int delay;
    private int current = 1;

    public CommandRite(Rite.BaseRiteParams baseParams, Rite.RiteParams params, List<List<String>> commands, int delay) {
        super(baseParams, params);
        this.commands = commands;
        this.delay = delay;
    }

    @Override
    protected boolean onStart(Rite.RiteParams params) {
        CommandSourceStack sourceStack = new CommandSourceStack((CommandSource)this, Vec3.atCenterOf((Vec3i)this.pos), new Vec2(0.0f, 0.0f), this.level, 2, "Command Rite", (Component)Component.literal((String)"Command Rite"), this.level.getServer(), null);
        if (this.delay == 0) {
            this.commands.forEach(list -> list.forEach(command -> this.level.getServer().getCommands().performPrefixedCommand(sourceStack, this.replacedVars((String)command, params.caster, params.target))));
        } else {
            this.commands.getFirst().forEach(c -> this.level.getServer().getCommands().performPrefixedCommand(sourceStack, this.replacedVars((String)c, params.caster, params.target)));
        }
        return this.delay > 0 && this.commands.size() > 1;
    }

    @Override
    protected boolean onTick(Rite.RiteParams params) {
        if (params.ticks() % this.delay == 0) {
            CommandSourceStack sourceStack = new CommandSourceStack((CommandSource)this, Vec3.atCenterOf((Vec3i)this.pos), new Vec2(0.0f, 0.0f), this.level, 2, "Command Rite", (Component)Component.literal((String)"Command Rite"), this.level.getServer(), null);
            this.commands.get(this.current++).forEach(c -> this.level.getServer().getCommands().performPrefixedCommand(sourceStack, this.replacedVars((String)c, params.caster, params.caster)));
        }
        return this.current < this.commands.size();
    }

    protected String replacedVars(String command, @Nullable UUID caster, @Nullable UUID target) {
        return command.replaceAll("@caster", caster != null ? caster.toString() : "@caster").replaceAll("@target", target != null ? target.toString() : "@target");
    }

    @Override
    protected void saveAdditional(CompoundTag tag, ServerLevel level) {
        tag.putInt("current", this.current);
    }

    @Override
    protected void loadAdditional(CompoundTag tag, ServerLevel level) {
        this.current = tag.getInt("current");
    }

    public void sendSystemMessage(Component component) {
    }

    public boolean acceptsSuccess() {
        return false;
    }

    public boolean acceptsFailure() {
        return false;
    }

    public boolean shouldInformAdmins() {
        return false;
    }
}

