/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.circle_magic.rites;

import java.util.List;
import net.favouriteless.enchanted.common.circle_magic.rites.Rite;
import net.favouriteless.enchanted.common.init.EParticleTypes;
import net.favouriteless.enchanted.common.init.ETags;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class BroilingRite
extends Rite {
    public static final float CIRCLE_RADIUS = 4.0f;
    private static final float RADIUS_SQR = 16.0f;
    private final RecipeManager.CachedCheck<SingleRecipeInput, SmeltingRecipe> smeltCheck = RecipeManager.createCheck((RecipeType)RecipeType.SMELTING);
    private final double burnChance;

    public BroilingRite(Rite.BaseRiteParams baseParams, Rite.RiteParams params, double burnChance) {
        super(baseParams, params);
        this.burnChance = burnChance;
    }

    @Override
    protected boolean onTick(Rite.RiteParams params) {
        if (params.ticks() % 5 != 0) {
            return true;
        }
        AABB bounds = new AABB((double)((float)this.pos.getX() - 4.0f), (double)this.pos.getY(), (double)((float)this.pos.getZ() - 4.0f), (double)((float)this.pos.getX() + 4.0f + 1.0f), (double)(this.pos.getY() + 1), (double)((float)this.pos.getZ() + 4.0f + 1.0f));
        List toCook = this.level.getEntitiesOfClass(ItemEntity.class, bounds, e -> e.position().subtract(this.pos.getCenter()).lengthSqr() < 16.0 && e.getItem().is(ETags.Items.RAW_FOODS));
        if (toCook.isEmpty()) {
            return false;
        }
        ItemEntity item = (ItemEntity)toCook.getFirst();
        SingleRecipeInput input = new SingleRecipeInput(item.getItem());
        RecipeHolder recipe = this.smeltCheck.getRecipeFor((RecipeInput)input, (Level)this.level).orElse(null);
        if (recipe == null) {
            return false;
        }
        int total = item.getItem().getCount();
        int burned = 0;
        for (int i = 0; i < total; ++i) {
            if (!(Math.random() < this.burnChance)) continue;
            ++burned;
        }
        if (burned < total) {
            ItemStack out = ((SmeltingRecipe)recipe.value()).assemble(input, (HolderLookup.Provider)this.level.registryAccess());
            out.setCount(total - burned);
            this.level.addFreshEntity((Entity)new ItemEntity((Level)this.level, item.getX(), item.getY(), item.getZ(), out));
        }
        if (burned > 0) {
            int count = burned / 16;
            if (Math.random() < (double)((float)(burned % 16) / 16.0f)) {
                ++count;
            }
            this.level.addFreshEntity((Entity)new ItemEntity((Level)this.level, item.getX(), item.getY(), item.getZ(), new ItemStack((ItemLike)Items.CHARCOAL, count)));
        }
        this.level.playSound(null, item.getX(), item.getY(), item.getZ(), SoundEvents.BLAZE_SHOOT, SoundSource.MASTER, 1.0f, 1.0f);
        this.level.sendParticles((ParticleOptions)ParticleTypes.SMALL_FLAME, item.getX(), item.getY(), item.getZ(), 25, 0.2, 0.2, 0.2, 0.0);
        this.level.sendParticles((ParticleOptions)EParticleTypes.BROILING_SEED.get(), (double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        item.discard();
        return true;
    }
}

