/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.circle_magic.rites;

import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.circle_magic.rites.Rite;
import net.favouriteless.enchanted.common.init.EParticleTypes;
import net.favouriteless.enchanted.common.init.ETags;
import net.favouriteless.enchanted.common.util.BlockPosUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class BlightRite
extends Rite {
    public static final int TICKS_PER_BLOCK = 3;
    protected final int radius;
    protected final int radiusSq;
    protected final double decayChance;
    protected final double zombieChance;
    protected int step = 1;

    public BlightRite(Rite.BaseRiteParams baseParams, Rite.RiteParams params, int radius, double decayChance, double zombieChance) {
        super(baseParams, params);
        this.radius = radius;
        this.radiusSq = radius * radius;
        this.decayChance = decayChance;
        this.zombieChance = zombieChance;
    }

    @Override
    protected boolean onStart(Rite.RiteParams params) {
        Entity caster = this.level.getEntity(params.caster);
        this.level.getEntitiesOfClass(LivingEntity.class, this.type.getBounds(this.pos), e -> e.position().distanceToSqr(this.pos.getCenter()) < (double)this.radiusSq).forEach(entity -> this.applyBlightEffects(caster, (LivingEntity)entity));
        return true;
    }

    @Override
    protected boolean onTick(Rite.RiteParams params) {
        if (params.ticks() % 3 != 0) {
            return true;
        }
        BlockPosUtils.iterableSphereHollow(this.pos, this.step).forEach(spherePos -> {
            if (Math.random() > this.decayChance) {
                return;
            }
            BlockState state = this.level.getBlockState((BlockPos)spherePos);
            if (state.isAir()) {
                return;
            }
            if (state.is(ETags.Blocks.BLIGHT_DECAYABLE_BLOCKS)) {
                Holder holder = BuiltInRegistries.BLOCK.getOrCreateTag(ETags.Blocks.BLIGHT_DECAY_BLOCKS).getRandomElement(Enchanted.RANDOMSOURCE).orElse(null);
                if (holder == null) {
                    return;
                }
                this.level.setBlockAndUpdate((BlockPos)spherePos, ((Block)holder.value()).defaultBlockState());
            } else if (state.is(ETags.Blocks.BLIGHT_DECAYABLE_PLANTS)) {
                this.level.setBlockAndUpdate((BlockPos)spherePos, Blocks.DEAD_BUSH.defaultBlockState());
            }
        });
        if (params.ticks() % 15 == 0) {
            this.level.playSound(null, this.pos, SoundEvents.ENDER_DRAGON_GROWL, SoundSource.MASTER, 0.1f, 1.0f);
            this.level.sendParticles((ParticleOptions)EParticleTypes.BLIGHT_SEED.get(), (double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
        return this.step++ < this.radius;
    }

    @Override
    protected void saveAdditional(CompoundTag tag, ServerLevel level) {
        tag.putInt("step", this.step);
    }

    @Override
    protected void loadAdditional(CompoundTag tag, ServerLevel level) {
        this.step = tag.getInt("step");
    }

    protected void applyBlightEffects(Entity caster, LivingEntity target) {
        Holder effectHolder;
        if (target instanceof Villager) {
            Villager villager = (Villager)target;
            if (Math.random() < this.zombieChance) {
                villager.convertTo(EntityType.ZOMBIE_VILLAGER, false);
                return;
            }
        }
        if ((effectHolder = (Holder)BuiltInRegistries.MOB_EFFECT.getOrCreateTag(ETags.MobEffects.BLIGHT_EFFECTS).getRandomElement(Enchanted.RANDOMSOURCE).orElse(null)) == null) {
            return;
        }
        if (target != caster) {
            target.addEffect(new MobEffectInstance(effectHolder, 100 + Enchanted.RANDOM.nextInt(101), Enchanted.RANDOM.nextInt(3)));
        }
    }
}

