/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.circle_magic.rites;

import java.util.HashMap;
import net.favouriteless.enchanted.common.circle_magic.CircleMagicShape;
import net.favouriteless.enchanted.common.circle_magic.rites.Rite;
import net.favouriteless.enchanted.common.init.EData;
import net.favouriteless.enchanted.common.init.EItems;
import net.favouriteless.enchanted.common.items.component.EDataComponents;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class BindTalismanRite
extends Rite {
    public BindTalismanRite(Rite.BaseRiteParams baseParams, Rite.RiteParams params) {
        super(baseParams, params);
    }

    @Override
    protected boolean onStart(Rite.RiteParams params) {
        Registry registry = this.level.registryAccess().registryOrThrow(EData.CIRCLE_SHAPE_REGISTRY);
        HashMap<CircleMagicShape, Block> shapes = new HashMap<CircleMagicShape, Block>();
        for (CircleMagicShape shape2 : registry) {
            Block block2 = shape2.getBlockAt((Level)this.level, this.pos);
            if (block2 == null) continue;
            shapes.put(shape2, block2);
        }
        if (shapes.isEmpty()) {
            return this.cancel();
        }
        HashMap component = new HashMap();
        shapes.forEach((shape, block) -> component.put(registry.getKey(shape), block));
        shapes.keySet().forEach(shape -> shape.remove((Level)this.level, this.pos));
        this.level.setBlockAndUpdate(this.pos, Blocks.AIR.defaultBlockState());
        ItemStack out = new ItemStack((ItemLike)EItems.CIRCLE_TALISMAN.get());
        out.set(EDataComponents.CIRCLE_MAGIC_SHAPE_MAP.get(), component);
        ItemEntity entity = new ItemEntity((Level)this.level, (double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5, out);
        this.level.addFreshEntity((Entity)entity);
        this.level.playSound(null, this.pos, SoundEvents.ZOMBIE_VILLAGER_CURE, SoundSource.MASTER, 0.5f, 1.0f);
        this.randomParticles((ParticleOptions)ParticleTypes.WITCH);
        return false;
    }
}

