/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.circle_magic.rites;

import java.util.List;
import java.util.UUID;
import net.favouriteless.enchanted.api.familiars.FamiliarSavedData;
import net.favouriteless.enchanted.api.familiars.FamiliarType;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.circle_magic.rites.Rite;
import net.favouriteless.enchanted.common.familiars.FamiliarTypes;
import net.favouriteless.enchanted.common.init.EParticleTypes;
import net.favouriteless.enchanted.common.init.ESoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class BindFamiliarRite
extends Rite {
    public static final int BIND_TICKS = 300;
    public static final int START_SOUND = 175;
    public static final Vec3 OFFSET = new Vec3(0.5, 2.5, 0.5);

    public BindFamiliarRite(Rite.BaseRiteParams baseParams, Rite.RiteParams params) {
        super(baseParams, params);
    }

    @Override
    protected boolean onStart(Rite.RiteParams params) {
        Entity target = this.findEntity(params.target);
        if (target == null) {
            return this.cancel();
        }
        Vec3 newPos = new Vec3(BindFamiliarRite.OFFSET.x + (double)this.pos.getX(), BindFamiliarRite.OFFSET.y + (double)this.pos.getY(), BindFamiliarRite.OFFSET.z + (double)this.pos.getZ());
        target.setNoGravity(true);
        this.level.playSound(null, target.getX(), target.getY(), target.getZ(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.NEUTRAL, 1.0f, 1.0f);
        double offset = (double)target.getBbWidth() / 1.5;
        this.level.sendParticles((ParticleOptions)ParticleTypes.PORTAL, target.getX(), target.getY(), target.getZ(), 20 + Enchanted.RANDOM.nextInt(10), offset, offset, offset, 0.0);
        target.teleportTo(newPos.x, newPos.y, newPos.z);
        this.level.sendParticles((ParticleOptions)ParticleTypes.PORTAL, target.getX(), target.getY(), target.getZ(), 20 + Enchanted.RANDOM.nextInt(10), offset, offset, offset, 0.0);
        this.level.sendParticles((ParticleOptions)EParticleTypes.BIND_FAMILIAR_SEED.get(), newPos.x, newPos.y, newPos.z, 1, 0.0, 0.0, 0.0, 0.0);
        return true;
    }

    @Override
    protected boolean onTick(Rite.RiteParams params) {
        Entity target = this.findEntity(params.target);
        if (target == null) {
            return false;
        }
        if (params.ticks() == 175) {
            this.level.playSound(null, target.getX(), target.getY(), target.getZ(), (SoundEvent)ESoundEvents.BIND_FAMILIAR.value(), SoundSource.MASTER, 1.5f, 1.0f);
        }
        if (params.ticks() >= 300) {
            FamiliarType<?, ?> type = FamiliarTypes.getByInput(target.getType());
            if (type == null) {
                return false;
            }
            Object familiar = type.getFor(this.level);
            familiar.setPos(target.getX(), target.getY(), target.getZ());
            familiar.setOwnerUUID(params.caster);
            familiar.setTame(true, true);
            familiar.setCustomName(target.getCustomName());
            familiar.setPersistenceRequired();
            FamiliarSavedData data = FamiliarSavedData.get((Level)this.level);
            data.setFamiliar(params.caster, type, (TamableAnimal)familiar);
            Enchanted.LOG.info("Familiar of type {} bound to {}", (Object)type.getId().toString(), (Object)params.caster);
            this.level.addFreshEntity(familiar);
            target.discard();
            return false;
        }
        double dx = (double)this.pos.getX() + BindFamiliarRite.OFFSET.x + Math.random() * 0.2 - 0.1;
        double dy = (double)this.pos.getY() + BindFamiliarRite.OFFSET.y + Math.random() * 0.2 - 0.1 - (double)target.getBbHeight() / 2.0;
        double dz = (double)this.pos.getZ() + BindFamiliarRite.OFFSET.z + Math.random() * 0.2 - 0.1;
        target.teleportTo(dx, dy, dz);
        return true;
    }

    @Override
    protected UUID findTargetUUID(ServerLevel level, BlockPos pos, Rite.RiteParams params) {
        List potentials = level.getEntitiesOfClass(TamableAnimal.class, this.type.getBounds(pos), e -> FamiliarTypes.getByInput(e.getType()) != null);
        for (TamableAnimal animal : potentials) {
            if (animal.getOwnerUUID() == null || !animal.getOwnerUUID().equals(params.caster)) continue;
            return animal.getUUID();
        }
        return null;
    }
}

