/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.circle_magic;

import com.mojang.serialization.Codec;
import java.util.function.Predicate;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;

public enum RiteWeatherRequirement implements StringRepresentable
{
    NONE(level -> true),
    CLEAR(level -> !level.isRaining() && !level.isThundering()),
    RAINING(Level::isRaining),
    THUNDERING(Level::isThundering);

    public static final Codec<RiteWeatherRequirement> CODEC;
    private final Predicate<Level> check;

    private RiteWeatherRequirement(Predicate<Level> check) {
        this.check = check;
    }

    public String getSerializedName() {
        return this.name().toLowerCase();
    }

    public boolean check(Level level) {
        return this.check.test(level);
    }

    static {
        CODEC = StringRepresentable.fromEnum(RiteWeatherRequirement::values);
    }
}

