/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.circle_magic;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.favouriteless.enchanted.api.Vec2i;
import net.favouriteless.enchanted.api.circle_magic.RiteFactory;
import net.favouriteless.enchanted.common.circle_magic.CircleMagicShape;
import net.favouriteless.enchanted.common.circle_magic.RiteWeatherRequirement;
import net.favouriteless.enchanted.common.circle_magic.rites.Rite;
import net.favouriteless.enchanted.common.init.EData;
import net.favouriteless.enchanted.common.util.ItemUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RiteType
implements Comparable<RiteType> {
    public static final Codec<RiteType> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.CODEC.listOf().fieldOf("items").forGetter(r -> r.items), (App)Codec.unboundedMap(CircleMagicShape.HOLDER_CODEC, (Codec)BuiltInRegistries.BLOCK.byNameCodec()).optionalFieldOf("shapes", Map.of()).forGetter(r -> r.shapes), (App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().listOf().optionalFieldOf("entities", List.of()).forGetter(r -> r.entities), (App)Codec.INT.optionalFieldOf("power", (Object)0).forGetter(r -> r.power), (App)Codec.INT.optionalFieldOf("tick_power", (Object)0).forGetter(r -> r.tickPower), (App)RiteWeatherRequirement.CODEC.optionalFieldOf("weather", (Object)RiteWeatherRequirement.NONE).forGetter(r -> r.weather), (App)Codec.pair((Codec)Codec.INT, (Codec)Codec.INT).optionalFieldOf("time", (Object)Pair.of((Object)0, (Object)24000)).forGetter(r -> r.timeRange), (App)RiteFactory.codec().fieldOf("factory").forGetter(r -> r.factory)).apply((Applicative)instance, RiteType::new));
    private final List<ItemStack> items;
    private final Map<Holder<CircleMagicShape>, Block> shapes;
    private final List<EntityType<?>> entities;
    private final int power;
    private final int tickPower;
    private final RiteFactory factory;
    private final RiteWeatherRequirement weather;
    private final Pair<Integer, Integer> timeRange;
    private final List<Vec2i> interiorPoints = new ArrayList<Vec2i>();
    private int radius = 1;

    public RiteType(List<ItemStack> items, Map<Holder<CircleMagicShape>, Block> shapes, List<EntityType<?>> entities, int power, int tickPower, RiteWeatherRequirement weather, Pair<Integer, Integer> timeRange, RiteFactory factory) {
        this.items = items;
        this.shapes = shapes;
        this.entities = entities;
        this.power = power;
        this.tickPower = tickPower;
        this.weather = weather;
        this.timeRange = timeRange;
        this.factory = factory;
        shapes.keySet().stream().map(Holder::value).forEach(shape -> {
            if (shape.getRadius() > this.radius) {
                this.radius = shape.getRadius();
            }
            this.interiorPoints.addAll(shape.getInteriorPoints());
        });
    }

    public boolean matches(Level level, BlockPos pos, List<Entity> inputs) {
        if (!this.weather.check(level)) {
            return false;
        }
        long time = level.getDayTime() % 24000L;
        if (time < (long)((Integer)this.timeRange.getFirst()).intValue()) {
            return false;
        }
        if (time > (long)((Integer)this.timeRange.getSecond()).intValue()) {
            return false;
        }
        for (Map.Entry<Holder<CircleMagicShape>, Block> entry : this.shapes.entrySet()) {
            if (((CircleMagicShape)entry.getKey().value()).matches(level, pos, entry.getValue())) continue;
            return false;
        }
        List<EntityType<?>> entities = this.getEntities();
        inputs.forEach(entity -> entities.remove(entity.getType()));
        if (!entities.isEmpty()) {
            return false;
        }
        List<ItemStack> items = this.getItems();
        for (Entity input : inputs) {
            if (!(input instanceof ItemEntity)) continue;
            ItemEntity itemEntity = (ItemEntity)input;
            ItemStack item = itemEntity.getItem();
            if (item.isEmpty()) break;
            for (ItemStack required : items) {
                if (!ItemUtils.isSameItemPartial(item, required)) continue;
                required.shrink(item.getCount());
            }
        }
        items.removeIf(ItemStack::isEmpty);
        return items.isEmpty();
    }

    public List<ItemStack> getItems() {
        return this.items.stream().map(ItemStack::copy).collect(Collectors.toList());
    }

    public List<EntityType<?>> getEntities() {
        return new ArrayList(this.entities);
    }

    public Map<Holder<CircleMagicShape>, Block> getShapes() {
        return this.shapes;
    }

    public int getPower() {
        return this.power;
    }

    public int getTickPower() {
        return this.tickPower;
    }

    public RiteWeatherRequirement getWeatherRequirement() {
        return this.weather;
    }

    public Pair<Integer, Integer> getTimeRange() {
        return this.timeRange;
    }

    public int getRadius() {
        return this.radius;
    }

    public AABB getBounds(BlockPos pos) {
        Vec3 center = pos.getBottomCenter();
        return new AABB(center.subtract((double)this.radius, 0.0, (double)this.radius), center.add((double)this.radius, 1.0, (double)this.radius));
    }

    public List<Vec2i> getInteriorPoints() {
        return this.interiorPoints;
    }

    @Nullable
    public List<ItemStack> getOutputs() {
        return this.factory.getOutputs();
    }

    public Rite create(ServerLevel level, BlockPos pos, UUID caster, List<ItemStack> consumedItems) {
        return this.factory.create(new Rite.BaseRiteParams(this, level, pos, this.tickPower), Rite.RiteParams.of(caster, consumedItems));
    }

    public Rite create(ServerLevel level, BlockPos pos) {
        return this.factory.create(new Rite.BaseRiteParams(this, level, pos, this.tickPower), Rite.RiteParams.empty());
    }

    public static RiteType getFirstMatching(Level level, BlockPos pos) {
        Registry reg = level.registryAccess().registryOrThrow(EData.RITE_TYPES_REGISTRY);
        List entities = level.getEntities(null, new AABB((double)(pos.getX() - 3), (double)pos.getY(), (double)(pos.getZ() - 3), (double)(pos.getX() + 4), (double)(pos.getY() + 1), (double)(pos.getZ() + 4)));
        Iterator it = reg.stream().sorted().iterator();
        while (it.hasNext()) {
            RiteType type = (RiteType)it.next();
            if (!type.matches(level, pos, entities)) continue;
            return type;
        }
        return null;
    }

    @Override
    public int compareTo(@NotNull RiteType o) {
        if (this.shapes.size() == o.shapes.size() && this.items.size() == o.items.size() && this.entities.size() == o.entities.size()) {
            return 0;
        }
        if (this.shapes.size() > o.shapes.size()) {
            return -1;
        }
        if (this.shapes.size() < o.shapes.size()) {
            return 1;
        }
        if (this.items.size() > o.items.size()) {
            return -1;
        }
        if (this.items.size() < o.items.size()) {
            return 1;
        }
        if (this.entities.size() > o.entities.size()) {
            return -1;
        }
        return 1;
    }
}

