/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.circle_magic;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.circle_magic.RiteType;
import net.favouriteless.enchanted.common.circle_magic.rites.Rite;
import net.favouriteless.enchanted.common.init.EData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class RiteManager
extends SavedData {
    private static final String NAME = "enchanted_rites";
    private final List<Rite> activeRites = new ArrayList<Rite>();
    public final ServerLevel level;

    public RiteManager(ServerLevel level) {
        this.level = level;
    }

    public static RiteManager get(ServerLevel level) {
        return (RiteManager)level.getDataStorage().computeIfAbsent(new SavedData.Factory(() -> new RiteManager(level), (tag, registries) -> RiteManager.load(level, tag), null), NAME);
    }

    public static void addRite(ServerLevel level, Rite rite) {
        RiteManager manager = RiteManager.get(level);
        manager.activeRites.add(rite);
        manager.setDirty();
    }

    public static void removeRite(ServerLevel level, Rite rite) {
        RiteManager manager = RiteManager.get(level);
        manager.activeRites.remove(rite);
        manager.setDirty();
    }

    public static void tick(ServerLevel level) {
        RiteManager manager = RiteManager.get(level);
        manager.activeRites.removeIf(rite -> !rite.tick());
        manager.setDirty();
    }

    public static Rite getRiteAt(ServerLevel level, BlockPos pos) {
        RiteManager manager = RiteManager.get(level);
        for (Rite rite : manager.activeRites) {
            if (!rite.getPos().equals((Object)pos)) continue;
            return rite;
        }
        return null;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        CompoundTag out = new CompoundTag();
        ListTag riteList = new ListTag();
        Registry registry = this.level.registryAccess().registryOrThrow(EData.RITE_TYPES_REGISTRY);
        for (Rite rite : this.activeRites) {
            ResourceLocation typeId = registry.getKey((Object)rite.getType());
            if (typeId == null) continue;
            CompoundTag riteTag = rite.save();
            riteTag.put("type", (Tag)ResourceLocation.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)typeId).getOrThrow());
            riteTag.put("pos", (Tag)BlockPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)rite.getPos()).getOrThrow());
            riteList.add((Object)riteTag);
        }
        out.put("rites", (Tag)riteList);
        return out;
    }

    public static RiteManager load(ServerLevel level, CompoundTag tag) {
        RiteManager manager = new RiteManager(level);
        ListTag riteList = tag.getList("rites", 10);
        Registry registry = level.registryAccess().registryOrThrow(EData.RITE_TYPES_REGISTRY);
        for (int i = 0; i < riteList.size(); ++i) {
            try {
                CompoundTag riteTag = riteList.getCompound(i);
                RiteType type = (RiteType)registry.get((ResourceLocation)ResourceLocation.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)riteTag.get("type")).getOrThrow());
                BlockPos pos = (BlockPos)BlockPos.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)riteTag.get("pos")).getOrThrow();
                Rite rite = type.create(level, pos);
                rite.load(riteTag);
                manager.activeRites.add(rite);
                continue;
            }
            catch (Exception e) {
                Enchanted.LOG.error("Failed to load Rite, skipping: {}", (Object)e.getMessage());
            }
        }
        return manager;
    }
}

