/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.blocks.entity;

import net.favouriteless.enchanted.common.blocks.FumeFunnelBlock;
import net.favouriteless.enchanted.common.blocks.WitchOvenBlock;
import net.favouriteless.enchanted.common.blocks.entity.ContainerBlockEntityBase;
import net.favouriteless.enchanted.common.blocks.entity.EBlockEntityTypes;
import net.favouriteless.enchanted.common.init.EItems;
import net.favouriteless.enchanted.common.init.ERecipeTypes;
import net.favouriteless.enchanted.common.init.ETags;
import net.favouriteless.enchanted.common.menus.WitchOvenMenu;
import net.favouriteless.enchanted.common.recipes.ByproductRecipe;
import net.favouriteless.enchanted.platform.CommonServices;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WitchOvenBlockEntity
extends ContainerBlockEntityBase
implements MenuProvider,
WorldlyContainer {
    private static final int[] TOP_SLOTS = new int[]{0};
    private static final int[] SIDE_SLOTS = new int[]{1};
    private static final int[] FACE_SLOTS = new int[]{2};
    private static final int[] BOTTOM_SLOTS = new int[]{3, 4};
    private final RecipeManager.CachedCheck<SingleRecipeInput, SmeltingRecipe> smeltCheck;
    private final RecipeManager.CachedCheck<SingleRecipeInput, ByproductRecipe> byproductCheck;
    private int burnProgress = 0;
    private int burnDuration = 0;
    private int cookProgress = 0;
    private int cookDuration = 200;
    private final ContainerData access = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> WitchOvenBlockEntity.this.burnProgress;
                case 1 -> WitchOvenBlockEntity.this.burnDuration;
                case 2 -> WitchOvenBlockEntity.this.cookProgress;
                case 3 -> WitchOvenBlockEntity.this.cookDuration;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    WitchOvenBlockEntity.this.burnProgress = value;
                }
                case 1: {
                    WitchOvenBlockEntity.this.burnDuration = value;
                }
                case 2: {
                    WitchOvenBlockEntity.this.cookProgress = value;
                }
                case 3: {
                    WitchOvenBlockEntity.this.cookDuration = value;
                }
            }
        }

        public int getCount() {
            return 4;
        }
    };

    public WitchOvenBlockEntity(BlockPos pos, BlockState state) {
        super(EBlockEntityTypes.WITCH_OVEN.get(), pos, state, (NonNullList<ItemStack>)NonNullList.withSize((int)5, (Object)ItemStack.EMPTY));
        this.smeltCheck = RecipeManager.createCheck((RecipeType)RecipeType.SMELTING);
        this.byproductCheck = RecipeManager.createCheck(ERecipeTypes.BYPRODUCT.get());
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, WitchOvenBlockEntity be) {
        boolean hasInput;
        boolean wasLit = be.isLit();
        boolean isChanged = false;
        if (be.isLit()) {
            --be.burnProgress;
        }
        ItemStack fuel = be.getFuel();
        boolean bl = hasInput = !be.getInput().isEmpty();
        if (be.isLit() || hasInput && !fuel.isEmpty()) {
            RecipeHolder holder;
            RecipeHolder recipeHolder = holder = hasInput ? (RecipeHolder)be.smeltCheck.getRecipeFor((RecipeInput)new SingleRecipeInput((ItemStack)be.inventory.get(0)), level).orElse(null) : null;
            if (holder != null) {
                boolean canBurn = be.canBurn(holder);
                if (!be.isLit() && canBurn) {
                    be.burnDuration = be.burnProgress = CommonServices.PLATFORM.getBurnTime(fuel, RecipeType.SMELTING);
                    if (be.isLit()) {
                        isChanged = true;
                        ItemStack remainder = CommonServices.PLATFORM.getCraftingRemainingItem(fuel);
                        fuel.shrink(1);
                        if (fuel.isEmpty()) {
                            be.inventory.set(2, (Object)(remainder == null ? ItemStack.EMPTY : remainder));
                        }
                    }
                }
                if (be.isLit() && canBurn) {
                    if (++be.cookProgress == be.cookDuration) {
                        be.cookProgress = 0;
                        be.cookDuration = be.getTotalCookTime();
                        be.burn((RecipeHolder<SmeltingRecipe>)holder);
                        isChanged = true;
                    }
                } else {
                    be.cookProgress = 0;
                }
            }
        } else if (!be.isLit() && be.cookProgress > 0) {
            be.cookProgress = Mth.clamp((int)(be.cookProgress - 2), (int)0, (int)be.cookDuration);
        }
        if (wasLit != be.isLit()) {
            level.setBlockAndUpdate(be.worldPosition, (BlockState)level.getBlockState(be.worldPosition).setValue((Property)WitchOvenBlock.LIT, (Comparable)Boolean.valueOf(be.isLit())));
            be.updateFumeFunnels();
            isChanged = true;
        }
        if (isChanged) {
            be.setChanged();
        }
    }

    private boolean canBurn(@NotNull RecipeHolder<SmeltingRecipe> recipe) {
        ItemStack input = this.getInput();
        if (input.is(ETags.Items.WITCH_OVEN_BLACKLIST)) {
            return false;
        }
        ItemStack result = ((SmeltingRecipe)recipe.value()).assemble(new SingleRecipeInput((ItemStack)this.inventory.get(0)), (HolderLookup.Provider)this.level.registryAccess());
        if (result.isEmpty()) {
            return false;
        }
        ItemStack output = this.getOutput();
        if (output.isEmpty()) {
            return true;
        }
        if (!ItemStack.isSameItemSameComponents((ItemStack)output, (ItemStack)result)) {
            return false;
        }
        return output.getCount() + result.getCount() <= output.getMaxStackSize();
    }

    private void burn(@NotNull RecipeHolder<SmeltingRecipe> recipe) {
        ItemStack input = this.getInput();
        ItemStack output = this.getOutput();
        ItemStack fuel = this.getFuel();
        if (Math.random() <= this.getByproductChance()) {
            this.createByproduct((RecipeHolder<ByproductRecipe>)((RecipeHolder)this.byproductCheck.getRecipeFor((RecipeInput)new SingleRecipeInput(input), this.level).orElse(null)));
        }
        ItemStack result = ((SmeltingRecipe)recipe.value()).assemble(new SingleRecipeInput((ItemStack)this.inventory.get(0)), (HolderLookup.Provider)this.level.registryAccess());
        if (output.isEmpty()) {
            this.inventory.set(3, (Object)result);
        } else {
            output.grow(result.getCount());
        }
        if (input.is(Items.WET_SPONGE) && !fuel.isEmpty() && fuel.is(Items.BUCKET)) {
            this.inventory.set(2, (Object)new ItemStack((ItemLike)Items.WATER_BUCKET));
        }
        input.shrink(1);
    }

    private void createByproduct(@Nullable RecipeHolder<ByproductRecipe> recipe) {
        if (recipe == null) {
            return;
        }
        ItemStack result = ((ByproductRecipe)recipe.value()).assemble((SingleRecipeInput)null, (HolderLookup.Provider)null);
        ItemStack input = this.getJarInput();
        if (input.getCount() < result.getCount()) {
            return;
        }
        ItemStack output = this.getJarOutput();
        if (!output.isEmpty()) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)result, (ItemStack)output) || result.getCount() + output.getCount() > output.getMaxStackSize()) {
                return;
            }
            output.grow(result.getCount());
        } else {
            this.inventory.set(4, (Object)result);
        }
        input.shrink(result.getCount());
    }

    private double getByproductChance() {
        FumeFunnelBlock funnel;
        double byproductChance = 0.3;
        Direction facing = (Direction)this.level.getBlockState(this.worldPosition).getValue((Property)WitchOvenBlock.FACING);
        BlockState left = this.level.getBlockState(this.worldPosition.offset(facing.getCounterClockWise().getNormal()));
        BlockState right = this.level.getBlockState(this.worldPosition.offset(facing.getClockWise().getNormal()));
        Block block = left.getBlock();
        if (block instanceof FumeFunnelBlock) {
            funnel = (FumeFunnelBlock)block;
            byproductChance += funnel.getByproductChance();
        }
        if ((block = right.getBlock()) instanceof FumeFunnelBlock) {
            funnel = (FumeFunnelBlock)block;
            byproductChance += funnel.getByproductChance();
        }
        return byproductChance;
    }

    private void updateFumeFunnels() {
        Direction facing = (Direction)this.level.getBlockState(this.worldPosition).getValue((Property)WitchOvenBlock.FACING);
        BlockPos left = this.worldPosition.offset(facing.getCounterClockWise().getNormal());
        BlockPos right = this.worldPosition.offset(facing.getClockWise().getNormal());
        BlockPos top = this.worldPosition.above();
        if (this.level.getBlockState(left).getBlock() instanceof FumeFunnelBlock) {
            this.level.setBlockAndUpdate(left, (BlockState)this.level.getBlockState(left).setValue((Property)WitchOvenBlock.LIT, (Comparable)Boolean.valueOf(this.isLit())));
        }
        if (this.level.getBlockState(right).getBlock() instanceof FumeFunnelBlock) {
            this.level.setBlockAndUpdate(right, (BlockState)this.level.getBlockState(right).setValue((Property)WitchOvenBlock.LIT, (Comparable)Boolean.valueOf(this.isLit())));
        }
        if (this.level.getBlockState(top).getBlock() instanceof FumeFunnelBlock) {
            this.level.setBlockAndUpdate(top, (BlockState)this.level.getBlockState(top).setValue((Property)WitchOvenBlock.LIT, (Comparable)Boolean.valueOf(this.isLit())));
        }
    }

    public ItemStack getInput() {
        return (ItemStack)this.inventory.get(0);
    }

    public ItemStack getJarInput() {
        return (ItemStack)this.inventory.get(1);
    }

    public ItemStack getFuel() {
        return (ItemStack)this.inventory.get(2);
    }

    public ItemStack getOutput() {
        return (ItemStack)this.inventory.get(3);
    }

    public ItemStack getJarOutput() {
        return (ItemStack)this.inventory.get(4);
    }

    @Override
    @NotNull
    public Component getDefaultName() {
        return Component.translatable((String)"container.enchanted.witch_oven");
    }

    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player player) {
        return new WitchOvenMenu(id, playerInventory, this, this.access);
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("burnTime", this.burnProgress);
        tag.putInt("burnTimeTotal", this.burnDuration);
        tag.putInt("cookTime", this.cookProgress);
        tag.putInt("cookTimeTotal", this.cookDuration);
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.burnProgress = tag.getInt("burnTime");
        this.burnDuration = tag.getInt("burnTimeTotal");
        this.cookProgress = tag.getInt("cookTime");
        this.cookDuration = tag.getInt("cookTimeTotal");
    }

    private boolean isLit() {
        return this.burnProgress > 0;
    }

    public int[] getSlotsForFace(@NotNull Direction face) {
        if (face == Direction.UP) {
            return TOP_SLOTS;
        }
        if (face == Direction.DOWN) {
            return BOTTOM_SLOTS;
        }
        if (face.getAxis() == ((Direction)this.level.getBlockState(this.worldPosition).getValue((Property)WitchOvenBlock.FACING)).getAxis()) {
            return FACE_SLOTS;
        }
        return SIDE_SLOTS;
    }

    public boolean canPlaceItemThroughFace(int index, @NotNull ItemStack stack, @Nullable Direction face) {
        if (index == 1) {
            return stack.getItem() == EItems.CLAY_JAR.get();
        }
        return index != 3 && index != 4;
    }

    public boolean canTakeItemThroughFace(int index, @NotNull ItemStack stack, @Nullable Direction face) {
        if (face == Direction.DOWN) {
            return index == 1 ? stack.is(Items.WATER_BUCKET) || stack.is(Items.BUCKET) : index == 3 || index == 4;
        }
        return true;
    }

    @Override
    public void setItem(int index, @NotNull ItemStack stack) {
        boolean matching = !stack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)this.getInput());
        this.inventory.set(index, (Object)stack);
        if (index == 0 && !matching) {
            this.cookDuration = this.getTotalCookTime();
            this.cookProgress = 0;
            this.setChanged();
        }
    }

    private int getTotalCookTime() {
        return this.smeltCheck.getRecipeFor((RecipeInput)new SingleRecipeInput(this.getInput()), this.level).map(holder -> ((SmeltingRecipe)holder.value()).getCookingTime()).orElse(200);
    }
}

