/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.blocks.entity;

import java.util.List;
import net.favouriteless.enchanted.client.particles.types.ColourOptions;
import net.favouriteless.enchanted.common.blocks.entity.CauldronBlockEntity;
import net.favouriteless.enchanted.common.blocks.entity.EBlockEntityTypes;
import net.favouriteless.enchanted.common.init.EBlocks;
import net.favouriteless.enchanted.common.init.EParticleTypes;
import net.favouriteless.enchanted.common.init.ERecipeTypes;
import net.favouriteless.enchanted.common.recipes.WitchCauldronRecipe;
import net.favouriteless.enchanted.common.recipes.recipe_inputs.ListInput;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.block.state.BlockState;

public class WitchCauldronBlockEntity
extends CauldronBlockEntity<WitchCauldronRecipe> {
    public WitchCauldronBlockEntity(BlockPos pos, BlockState state) {
        super(EBlockEntityTypes.WITCH_CAULDRON.get(), pos, state, 3, 200);
    }

    @Override
    public double getWaterStartY(BlockState state) {
        return 0.0625;
    }

    @Override
    public double getWaterMaxHeight() {
        return 0.4375;
    }

    @Override
    public double getWaterWidth() {
        return 0.75;
    }

    @Override
    public void handleCookParticles(long time) {
        double dx = (double)this.worldPosition.getX() + 0.5;
        double dy = (double)this.worldPosition.getY() + this.getWaterY(EBlocks.WITCH_CAULDRON.get().defaultBlockState());
        double dz = (double)this.worldPosition.getZ() + 0.5;
        this.level.addParticle((ParticleOptions)new ColourOptions(EParticleTypes.CAULDRON_COOK.get(), FastColor.ARGB32.color((int)this.getRed(time), (int)this.getGreen(time), (int)this.getBlue(time))), dx, dy, dz, 0.0, 0.0, 0.0);
    }

    @Override
    protected void matchRecipes() {
        if (this.level != null) {
            this.setPotentialRecipes(this.level.getRecipeManager().getRecipesFor(ERecipeTypes.WITCH_CAULDRON.get(), (RecipeInput)ListInput.of((List<ItemStack>)this.inventory), this.level));
        }
    }

    @Override
    protected Component getDefaultName() {
        return Component.translatable((String)"container.witch_cauldron");
    }
}

