/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.blocks.entity;

import net.favouriteless.enchanted.api.power.IPowerConsumer;
import net.favouriteless.enchanted.api.power.IPowerProvider;
import net.favouriteless.enchanted.api.power.PowerHelper;
import net.favouriteless.enchanted.common.altar.SimplePowerPosHolder;
import net.favouriteless.enchanted.common.blocks.entity.ContainerBlockEntityBase;
import net.favouriteless.enchanted.common.blocks.entity.EBlockEntityTypes;
import net.favouriteless.enchanted.common.init.ERecipeTypes;
import net.favouriteless.enchanted.common.menus.SpinningWheelMenu;
import net.favouriteless.enchanted.common.recipes.SpinningRecipe;
import net.favouriteless.enchanted.common.recipes.recipe_inputs.ListInput;
import net.favouriteless.enchanted.common.util.ItemUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpinningWheelBlockEntity
extends ContainerBlockEntityBase
implements IPowerConsumer,
MenuProvider,
WorldlyContainer {
    private static final int[] INPUT_SLOTS = new int[]{0, 1, 2};
    private static final int[] BOTTOM_SLOTS = new int[]{3};
    private final SimplePowerPosHolder posHolder;
    private final RecipeManager.CachedCheck<ListInput, SpinningRecipe> spinCheck;
    private int spinDuration = 300;
    private int spinProgress = 0;
    private boolean isSpinning = false;
    public ContainerData access = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> SpinningWheelBlockEntity.this.spinProgress;
                case 1 -> SpinningWheelBlockEntity.this.spinDuration;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            if (index == 0) {
                SpinningWheelBlockEntity.this.spinProgress = value;
            } else if (index == 2) {
                SpinningWheelBlockEntity.this.spinDuration = value;
            }
        }

        public int getCount() {
            return 2;
        }
    };

    public SpinningWheelBlockEntity(BlockPos pos, BlockState state) {
        super(EBlockEntityTypes.SPINNING_WHEEL.get(), pos, state, (NonNullList<ItemStack>)NonNullList.withSize((int)4, (Object)ItemStack.EMPTY));
        this.posHolder = new SimplePowerPosHolder(pos);
        this.spinCheck = RecipeManager.createCheck(ERecipeTypes.SPINNING.get());
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, SpinningWheelBlockEntity be) {
        RecipeHolder recipe = be.spinCheck.getRecipeFor((RecipeInput)ListInput.of(be.inventory.subList(0, 3)), level).orElse(null);
        boolean wasSpinning = be.spinProgress > 0;
        IPowerProvider provider = PowerHelper.tryGetPowerProvider(level, be.posHolder);
        if (recipe != null && be.canSpin((RecipeHolder<SpinningRecipe>)recipe) && (((SpinningRecipe)recipe.value()).getPower() == 0 || provider != null && provider.tryConsume((double)((SpinningRecipe)recipe.value()).getPower() / (double)be.spinDuration))) {
            if (++be.spinProgress == be.spinDuration) {
                be.spinProgress = 0;
                be.spinDuration = ((SpinningRecipe)recipe.value()).getDuration();
                be.spin((RecipeHolder<SpinningRecipe>)recipe);
            }
        } else {
            be.spinProgress = 0;
        }
        if (wasSpinning != be.isSpinning()) {
            be.updateBlock();
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, SpinningWheelBlockEntity be) {
        be.spinProgress = be.isSpinning ? ++be.spinProgress : 0;
    }

    protected void spin(@NotNull RecipeHolder<SpinningRecipe> recipe) {
        block0: for (ItemStack recipeStack : ((SpinningRecipe)recipe.value()).getInputs()) {
            for (int i = 0; i < 3; ++i) {
                ItemStack input = (ItemStack)this.inventory.get(i);
                if (!ItemUtils.isSameItemPartial(input, recipeStack)) continue;
                input.shrink(recipeStack.getCount());
                continue block0;
            }
        }
        ItemStack result = ((SpinningRecipe)recipe.value()).assemble((ListInput)null, (HolderLookup.Provider)null);
        ItemStack output = (ItemStack)this.inventory.get(3);
        if (output.isEmpty()) {
            this.inventory.set(3, (Object)result);
        } else {
            output.grow(result.getCount());
        }
    }

    private boolean canSpin(@NotNull RecipeHolder<SpinningRecipe> recipe) {
        ItemStack result = ((SpinningRecipe)recipe.value()).assemble((ListInput)null, (HolderLookup.Provider)null);
        if (result.isEmpty()) {
            return false;
        }
        ItemStack output = (ItemStack)this.inventory.get(3);
        if (output.isEmpty()) {
            return true;
        }
        if (ItemStack.isSameItemSameComponents((ItemStack)result, (ItemStack)output)) {
            return output.getCount() + result.getCount() <= output.getMaxStackSize();
        }
        return false;
    }

    @Override
    public Component getDefaultName() {
        return Component.translatable((String)"container.enchanted.spinning_wheel");
    }

    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new SpinningWheelMenu(id, inventory, this, this.access);
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("posHolder", (Tag)this.posHolder.serialize());
        tag.putInt("spinProgress", this.spinProgress);
        tag.putInt("spinDuration", this.spinDuration);
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("posHolder")) {
            this.posHolder.deserialize(tag.getCompound("posHolder"));
        }
        this.spinProgress = tag.getInt("spinProgress");
        this.isSpinning = tag.getBoolean("isSpinning");
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider registries) {
        CompoundTag nbt = super.getUpdateTag(registries);
        nbt.putBoolean("isSpinning", this.spinProgress > 0);
        return nbt;
    }

    @Override
    @NotNull
    public IPowerConsumer.IPowerPosHolder getPosHolder() {
        return this.posHolder;
    }

    public int getSpinProgress() {
        return this.spinProgress;
    }

    public boolean isSpinning() {
        return this.spinProgress > 0;
    }

    public int[] getSlotsForFace(@NotNull Direction face) {
        if (face == Direction.DOWN) {
            return BOTTOM_SLOTS;
        }
        return INPUT_SLOTS;
    }

    public boolean canPlaceItemThroughFace(int index, @NotNull ItemStack stack, @Nullable Direction face) {
        return index != 3;
    }

    public boolean canTakeItemThroughFace(int index, @NotNull ItemStack stack, @Nullable Direction face) {
        return index == 3;
    }

    @Override
    public void setItem(int index, @NotNull ItemStack stack) {
        boolean changed = stack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)((ItemStack)this.inventory.get(index)), (ItemStack)stack);
        this.inventory.set(index, (Object)stack);
        if (index != 4 && changed) {
            this.spinDuration = this.getTotalSpinTime();
            this.spinProgress = 0;
            this.updateBlock();
            this.setChanged();
        }
    }

    private int getTotalSpinTime() {
        return this.spinCheck.getRecipeFor((RecipeInput)ListInput.of(this.inventory.subList(0, 3)), this.level).map(holder -> ((SpinningRecipe)holder.value()).getDuration()).orElse(300);
    }
}

