/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.blocks.entity;

import net.favouriteless.enchanted.common.blocks.entity.EBlockEntityTypes;
import net.favouriteless.enchanted.common.menus.PoppetShelfMenu;
import net.favouriteless.enchanted.common.poppet.PoppetShelfInventory;
import net.favouriteless.enchanted.common.poppet.PoppetShelfManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class PoppetShelfBlockEntity
extends BlockEntity
implements MenuProvider {
    public PoppetShelfInventory inventory = null;

    public PoppetShelfBlockEntity(BlockPos pos, BlockState state) {
        super(EBlockEntityTypes.POPPET_SHELF.get(), pos, state);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.enchanted.poppet_shelf");
    }

    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new PoppetShelfMenu(id, inventory, this);
    }

    public void updateBlock() {
        if (this.level != null && !this.level.isClientSide) {
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, state, state, 2);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        if (tag.contains("Items")) {
            this.getInventory().load(tag, registries);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.getInventory().save(tag, registries);
        return tag;
    }

    public PoppetShelfInventory getInventory() {
        if (this.inventory == null) {
            this.inventory = this.level.isClientSide ? new PoppetShelfInventory(this.level, this.worldPosition) : PoppetShelfManager.getInventoryFor(this);
        }
        return this.inventory;
    }
}

