/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.blocks.entity;

import java.util.List;
import net.favouriteless.enchanted.client.particles.types.ColourOptions;
import net.favouriteless.enchanted.common.blocks.cauldrons.KettleBlock;
import net.favouriteless.enchanted.common.blocks.entity.CauldronBlockEntity;
import net.favouriteless.enchanted.common.blocks.entity.EBlockEntityTypes;
import net.favouriteless.enchanted.common.init.EParticleTypes;
import net.favouriteless.enchanted.common.init.ERecipeTypes;
import net.favouriteless.enchanted.common.recipes.KettleRecipe;
import net.favouriteless.enchanted.common.recipes.recipe_inputs.ListInput;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class KettleBlockEntity
extends CauldronBlockEntity<KettleRecipe> {
    public KettleBlockEntity(BlockPos pos, BlockState state) {
        super(EBlockEntityTypes.KETTLE.get(), pos, state, 1, 160);
    }

    @Override
    public double getWaterStartY(BlockState state) {
        return (Integer)state.getValue((Property)KettleBlock.TYPE) == 1 ? 0.1875 : 0.0625;
    }

    @Override
    public double getWaterMaxHeight() {
        return 0.25;
    }

    @Override
    public double getWaterWidth() {
        return 0.375;
    }

    @Override
    public void handleCookParticles(long time) {
        if (Math.random() > 0.5) {
            double dx = (double)this.worldPosition.getX() + Math.random();
            double dy = (double)this.worldPosition.getY() + Math.random();
            double dz = (double)this.worldPosition.getZ() + Math.random();
            this.level.addParticle((ParticleOptions)new ColourOptions(EParticleTypes.KETTLE_COOK.get(), FastColor.ARGB32.color((int)this.getRed(time), (int)this.getGreen(time), (int)this.getBlue(time))), dx, dy, dz, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void matchRecipes() {
        if (this.level != null) {
            this.setPotentialRecipes(this.level.getRecipeManager().getRecipesFor(ERecipeTypes.KETTLE.get(), (RecipeInput)ListInput.of((List<ItemStack>)this.inventory), this.level));
        }
    }

    @Override
    protected Component getDefaultName() {
        return Component.translatable((String)"container.enchanted.kettle");
    }
}

