/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.blocks.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.favouriteless.enchanted.api.power.IPowerConsumer;
import net.favouriteless.enchanted.api.power.IPowerProvider;
import net.favouriteless.enchanted.api.power.PowerHelper;
import net.favouriteless.enchanted.common.ServerConfig;
import net.favouriteless.enchanted.common.altar.SimplePowerPosHolder;
import net.favouriteless.enchanted.common.blocks.entity.EBlockEntityTypes;
import net.favouriteless.enchanted.common.circle_magic.RiteManager;
import net.favouriteless.enchanted.common.circle_magic.RiteType;
import net.favouriteless.enchanted.common.circle_magic.rites.Rite;
import net.favouriteless.enchanted.common.init.EData;
import net.favouriteless.enchanted.common.init.EItems;
import net.favouriteless.enchanted.common.util.ItemUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class GoldChalkBlockEntity
extends BlockEntity
implements IPowerConsumer {
    private final SimplePowerPosHolder posHolder;
    private boolean isExecuting;
    private boolean isInitialising = false;
    private RiteType type;
    private List<ItemStack> itemsToConsume;
    private List<EntityType<?>> entitiesToConsume;
    private UUID caster;
    private List<ItemStack> itemsConsumed = new ArrayList<ItemStack>();

    public GoldChalkBlockEntity(BlockPos pos, BlockState state) {
        super(EBlockEntityTypes.GOLD_CHALK.get(), pos, state);
        this.posHolder = new SimplePowerPosHolder(pos);
    }

    public void use(Level level, BlockPos pos, Player player) {
        if (!level.isClientSide) {
            if (this.isExecuting) {
                Rite rite = RiteManager.getRiteAt((ServerLevel)level, this.worldPosition);
                if (rite != null) {
                    rite.stop();
                    RiteManager.removeRite((ServerLevel)level, rite);
                } else {
                    this.detatch();
                }
            } else if (!this.isInitialising) {
                this.type = RiteType.getFirstMatching(level, pos);
                if (this.type != null) {
                    ResourceLocation key = level.registryAccess().registryOrThrow(EData.RITE_TYPES_REGISTRY).getKey((Object)this.type);
                    if (key == null || ((List)ServerConfig.INSTANCE.disabledRites.get()).contains(key.toString())) {
                        player.displayClientMessage((Component)Component.literal((String)"This rite has been disabled in the config.").withStyle(ChatFormatting.RED), false);
                        level.playSound(null, this.worldPosition, (SoundEvent)SoundEvents.NOTE_BLOCK_SNARE.value(), SoundSource.MASTER, 1.0f, 1.0f);
                        this.type = null;
                        return;
                    }
                    this.itemsToConsume = this.type.getItems();
                    this.entitiesToConsume = this.type.getEntities();
                    this.caster = player.getUUID();
                    this.isInitialising = true;
                } else {
                    level.playSound(null, this.worldPosition, (SoundEvent)SoundEvents.NOTE_BLOCK_SNARE.value(), SoundSource.MASTER, 1.0f, 1.0f);
                }
            }
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, GoldChalkBlockEntity be) {
        if (!be.isInitialising) {
            if (be.isExecuting) {
                be.createExecutingParticles();
            }
        } else {
            be.createExecutingParticles();
            if (level.getGameTime() % 20L != 0L) {
                return;
            }
            be.itemsToConsume.removeIf(ItemStack::isEmpty);
            if (!be.isDoneConsuming()) {
                if (!be.tryConsumeNext() && !be.isDoneConsuming()) {
                    be.cancel();
                }
            } else {
                IPowerProvider provider = PowerHelper.tryGetPowerProvider(level, be.posHolder);
                int power = be.type.getPower();
                if (power == 0 || provider != null && provider.tryConsume(power)) {
                    be.isExecuting = true;
                    be.isInitialising = false;
                    Rite rite = be.type.create((ServerLevel)level, be.worldPosition, be.caster, be.itemsConsumed);
                    be.itemsConsumed = new ArrayList<ItemStack>();
                    RiteManager.addRite((ServerLevel)level, rite);
                    rite.start();
                } else {
                    be.cancel();
                }
            }
        }
        GoldChalkBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
    }

    protected void createExecutingParticles() {
        double dx = (double)this.worldPosition.getX() + Math.random();
        double dy = (double)this.worldPosition.getY() + Math.random() * 0.3;
        double dz = (double)this.worldPosition.getZ() + Math.random();
        ((ServerLevel)this.level).sendParticles((ParticleOptions)new DustParticleOptions(new Vector3f(0.99607843f, 0.36862746f, 0.36862746f), 1.0f), dx, dy, dz, 1, 0.0, 0.0, 0.0, 0.0);
    }

    protected boolean isDoneConsuming() {
        return this.itemsToConsume.isEmpty() && this.entitiesToConsume.isEmpty();
    }

    public void detatch() {
        this.isExecuting = false;
        this.type = null;
        this.isInitialising = false;
    }

    protected void cancel() {
        this.isExecuting = false;
        this.isInitialising = false;
        this.type = null;
        this.itemsToConsume = null;
        this.entitiesToConsume = null;
        if (!this.level.isClientSide) {
            this.level.playSound(null, this.worldPosition, (SoundEvent)SoundEvents.NOTE_BLOCK_SNARE.value(), SoundSource.MASTER, 1.0f, 1.0f);
            for (ItemStack stack : this.itemsConsumed) {
                ItemEntity entity = new ItemEntity(this.level, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5, stack);
                this.level.addFreshEntity((Entity)entity);
            }
        }
        this.itemsConsumed.clear();
    }

    protected boolean tryConsumeNext() {
        if (this.tryConsumeItem()) {
            return true;
        }
        return this.tryConsumeEntity();
    }

    protected boolean tryConsumeItem() {
        List entities = this.level.getEntitiesOfClass(ItemEntity.class, new AABB((double)(this.worldPosition.getX() - 3), (double)this.worldPosition.getY(), (double)(this.worldPosition.getZ() - 3), (double)(this.worldPosition.getX() + 4), (double)(this.worldPosition.getY() + 1), (double)(this.worldPosition.getZ() + 4)));
        for (ItemEntity entity : entities) {
            ItemStack item = entity.getItem();
            for (ItemStack required : this.itemsToConsume) {
                if (!ItemUtils.isSameItemPartial(item, required)) continue;
                this.createConsumeEffect((Entity)entity);
                int toConsume = Math.min(required.getCount(), item.getCount());
                if (!entity.getItem().is(EItems.ATTUNED_STONE_CHARGED.get())) {
                    ItemStack copy = item.copy();
                    copy.setCount(toConsume);
                    this.itemsConsumed.add(copy);
                    item.shrink(toConsume);
                    if (item.isEmpty()) {
                        entity.discard();
                    }
                } else {
                    entity.setItem(new ItemStack((ItemLike)EItems.ATTUNED_STONE.get(), toConsume));
                }
                required.shrink(toConsume);
                return true;
            }
        }
        return false;
    }

    protected boolean tryConsumeEntity() {
        List entities = this.level.getEntities(null, new AABB((double)(this.worldPosition.getX() - 3), (double)this.worldPosition.getY(), (double)(this.worldPosition.getZ() - 3), (double)(this.worldPosition.getX() + 4), (double)(this.worldPosition.getY() + 1), (double)(this.worldPosition.getZ() + 4)));
        for (Entity entity : entities) {
            if (!this.entitiesToConsume.remove(entity.getType())) continue;
            entity.kill();
            return true;
        }
        return false;
    }

    protected void createConsumeEffect(Entity entity) {
        if (!this.level.isClientSide) {
            this.level.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.CHICKEN_EGG, SoundSource.MASTER, 1.0f, 1.0f);
            ((ServerLevel)this.level).sendParticles((ParticleOptions)ParticleTypes.CLOUD, entity.getX(), entity.getY(), entity.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put("posHolder", (Tag)this.posHolder.serialize());
        tag.putBoolean("isExecuting", this.isExecuting);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        this.posHolder.deserialize(tag.getCompound("posHolder"));
        this.isExecuting = tag.getBoolean("isExecuting");
    }

    public boolean tryConsumePower(int amount) {
        IPowerProvider provider = PowerHelper.tryGetPowerProvider(this.level, this.posHolder);
        return amount == 0 || provider != null && provider.tryConsume(amount);
    }

    @Override
    @NotNull
    public IPowerConsumer.IPowerPosHolder getPosHolder() {
        return this.posHolder;
    }
}

