/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.blocks.entity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.favouriteless.enchanted.api.power.IPowerConsumer;
import net.favouriteless.enchanted.api.power.IPowerProvider;
import net.favouriteless.enchanted.api.power.PowerHelper;
import net.favouriteless.enchanted.common.altar.SimplePowerPosHolder;
import net.favouriteless.enchanted.common.blocks.entity.ContainerBlockEntityBase;
import net.favouriteless.enchanted.common.blocks.entity.EBlockEntityTypes;
import net.favouriteless.enchanted.common.init.EItems;
import net.favouriteless.enchanted.common.init.ERecipeTypes;
import net.favouriteless.enchanted.common.menus.DistilleryMenu;
import net.favouriteless.enchanted.common.recipes.DistillingRecipe;
import net.favouriteless.enchanted.common.recipes.recipe_inputs.ListInput;
import net.favouriteless.enchanted.common.util.ItemUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class DistilleryBlockEntity
extends ContainerBlockEntityBase
implements IPowerConsumer,
MenuProvider,
WorldlyContainer {
    private static final int[] TOP_SLOTS = new int[]{1, 2};
    private static final int[] SIDE_SLOTS = new int[]{0};
    private static final int[] BOTTOM_SLOTS = new int[]{3, 4, 5, 6};
    private final RecipeManager.CachedCheck<ListInput, DistillingRecipe> recipeCheck;
    private final SimplePowerPosHolder posHolder;
    private boolean isBurning = false;
    private int cookProgress = 0;
    private int cookDuration = 200;
    private final ContainerData data = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> DistilleryBlockEntity.this.cookProgress;
                case 1 -> DistilleryBlockEntity.this.cookDuration;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    DistilleryBlockEntity.this.cookProgress = value;
                }
                case 1: {
                    DistilleryBlockEntity.this.cookDuration = value;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };

    public DistilleryBlockEntity(BlockPos pos, BlockState state) {
        super(EBlockEntityTypes.DISTILLERY.get(), pos, state, (NonNullList<ItemStack>)NonNullList.withSize((int)7, (Object)ItemStack.EMPTY));
        this.posHolder = new SimplePowerPosHolder(pos);
        this.recipeCheck = RecipeManager.createCheck(ERecipeTypes.DISTILLING.get());
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, DistilleryBlockEntity be) {
        IPowerProvider powerProvider = PowerHelper.tryGetPowerProvider(level, be.posHolder);
        boolean wasBurning = be.isBurning;
        RecipeHolder recipe = be.recipeCheck.getRecipeFor((RecipeInput)ListInput.of(be.inventory.subList(0, 4)), level).orElse(null);
        if (recipe != null && be.canDistill((RecipeHolder<DistillingRecipe>)recipe) && (((DistillingRecipe)recipe.value()).power() == 0 || powerProvider != null && powerProvider.tryConsume((double)((DistillingRecipe)recipe.value()).power() / (double)((DistillingRecipe)recipe.value()).duration()))) {
            be.isBurning = true;
            if (++be.cookProgress == be.cookDuration) {
                be.cookProgress = 0;
                be.distill((RecipeHolder<DistillingRecipe>)recipe);
            }
        } else {
            be.isBurning = false;
            if (be.cookProgress > 0) {
                be.cookProgress = Mth.clamp((int)(be.cookProgress - 2), (int)0, (int)be.cookDuration);
            }
        }
        if (wasBurning != be.isBurning) {
            level.setBlock(be.worldPosition, (BlockState)level.getBlockState(be.worldPosition).setValue((Property)AbstractFurnaceBlock.LIT, (Comparable)Boolean.valueOf(be.isBurning)), 3);
        }
        be.setChanged();
    }

    private void distill(@NotNull RecipeHolder<DistillingRecipe> recipe) {
        block0: for (ItemStack recipeItem : ((DistillingRecipe)recipe.value()).inputs()) {
            for (int i = 0; i < 3; ++i) {
                ItemStack inputItem = (ItemStack)this.inventory.get(i);
                if (!ItemUtils.isSameItemPartial(inputItem, recipeItem) || inputItem.getCount() < recipeItem.getCount()) continue;
                inputItem.shrink(recipeItem.getCount());
                continue block0;
            }
        }
        List<ItemStack> itemsOut = ((DistillingRecipe)recipe.value()).outputs();
        block2: for (ItemStack recipeItem : itemsOut) {
            int i;
            for (i = 3; i < this.inventory.size(); ++i) {
                ItemStack outputItem = (ItemStack)this.inventory.get(i);
                if (!ItemStack.isSameItemSameComponents((ItemStack)recipeItem, (ItemStack)outputItem)) continue;
                int amount = Math.min(outputItem.getMaxStackSize() - outputItem.getCount(), recipeItem.getCount());
                outputItem.grow(amount);
                recipeItem.shrink(amount);
                if (recipeItem.isEmpty()) break;
            }
            if (recipeItem.isEmpty()) continue;
            for (i = 3; i < this.inventory.size(); ++i) {
                if (!((ItemStack)this.inventory.get(i)).isEmpty()) continue;
                this.inventory.set(i, (Object)recipeItem);
                continue block2;
            }
        }
    }

    private boolean canDistill(@NotNull RecipeHolder<DistillingRecipe> recipe) {
        int i;
        ArrayList<ItemStack> itemsOut = new ArrayList<ItemStack>(((DistillingRecipe)recipe.value()).outputs());
        Iterator iterator = itemsOut.iterator();
        block0: while (iterator.hasNext()) {
            ItemStack result = (ItemStack)iterator.next();
            for (i = 3; i < this.inventory.size(); ++i) {
                ItemStack output = (ItemStack)this.inventory.get(i);
                if (!ItemStack.isSameItemSameComponents((ItemStack)result, (ItemStack)output)) continue;
                if (result.getCount() + output.getCount() <= output.getMaxStackSize()) {
                    iterator.remove();
                    continue block0;
                }
                result.shrink(output.getMaxStackSize() - output.getCount());
            }
        }
        int emptySpaces = 0;
        for (i = 3; i < this.inventory.size(); ++i) {
            if (!((ItemStack)this.inventory.get(i)).isEmpty()) continue;
            ++emptySpaces;
        }
        return emptySpaces >= itemsOut.size();
    }

    private static int getTotalCookTime(Level level, DistilleryBlockEntity be) {
        return be.recipeCheck.getRecipeFor((RecipeInput)ListInput.of(be.inventory.subList(0, 4)), level).map(holder -> ((DistillingRecipe)holder.value()).duration()).orElse(200);
    }

    @Override
    public Component getDefaultName() {
        return Component.translatable((String)"container.enchanted.distillery");
    }

    public AbstractContainerMenu createMenu(int id, @NotNull Inventory playerInventory, @NotNull Player player) {
        return new DistilleryMenu(id, playerInventory, this, this.data);
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("posHolder", (Tag)this.posHolder.serialize());
        tag.putBoolean("isBurning", this.isBurning);
        tag.putInt("cookTime", this.cookProgress);
        tag.putInt("cookTimeTotal", this.cookDuration);
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.posHolder.deserialize(tag.getCompound("posHolder"));
        this.isBurning = tag.getBoolean("isBurning");
        this.cookProgress = tag.getInt("cookTime");
        this.cookDuration = tag.getInt("cookTimeTotal");
    }

    @Override
    @NotNull
    public IPowerConsumer.IPowerPosHolder getPosHolder() {
        return this.posHolder;
    }

    public int[] getSlotsForFace(@NotNull Direction face) {
        if (face == Direction.UP) {
            return TOP_SLOTS;
        }
        if (face == Direction.DOWN) {
            return BOTTOM_SLOTS;
        }
        return SIDE_SLOTS;
    }

    public boolean canPlaceItemThroughFace(int index, @NotNull ItemStack stack, Direction face) {
        if (index < 3) {
            return index != 0 || stack.is(EItems.CLAY_JAR.get());
        }
        return false;
    }

    public boolean canTakeItemThroughFace(int index, @NotNull ItemStack stack, Direction face) {
        return index > 2;
    }

    @Override
    public void setItem(int index, @NotNull ItemStack stack) {
        boolean matching = !stack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)((ItemStack)this.inventory.get(index)));
        this.inventory.set(index, (Object)stack);
        if (index < 3 && !matching) {
            this.cookDuration = DistilleryBlockEntity.getTotalCookTime(this.level, this);
            this.cookProgress = 0;
            this.setChanged();
        }
    }
}

