/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.blocks.entity;

import java.util.ArrayList;
import java.util.List;
import net.favouriteless.enchanted.api.power.IPowerConsumer;
import net.favouriteless.enchanted.api.power.IPowerProvider;
import net.favouriteless.enchanted.api.power.PowerHelper;
import net.favouriteless.enchanted.client.client_handlers.block_entities.CauldronClientHandler;
import net.favouriteless.enchanted.client.particles.types.ColourOptions;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.ServerConfig;
import net.favouriteless.enchanted.common.altar.SimplePowerPosHolder;
import net.favouriteless.enchanted.common.blocks.entity.ContainerBlockEntityBase;
import net.favouriteless.enchanted.common.init.EParticleTypes;
import net.favouriteless.enchanted.common.init.ETags;
import net.favouriteless.enchanted.common.recipes.CauldronTypeRecipe;
import net.favouriteless.enchanted.common.recipes.recipe_inputs.ListInput;
import net.favouriteless.enchanted.common.util.ItemUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CauldronBlockEntity<T extends CauldronTypeRecipe>
extends ContainerBlockEntityBase
implements IPowerConsumer,
WorldlyContainer {
    private final SimplePowerPosHolder posHolder;
    private final int fluidCapacity;
    private int fluidAmount = 0;
    private static final int WARMING_MAX = 80;
    private static final int BLENDING_MILLISECONDS = 500;
    private final int cookDuration;
    private final List<T> potentialRecipes = new ArrayList<T>();
    protected ItemStack itemOut = ItemStack.EMPTY;
    protected int cookProgress = 0;
    protected int warmingUp = 0;
    public boolean isFailed = false;
    public boolean isComplete = false;
    private boolean firstTick = true;
    private boolean hasItems = false;
    private int targetRed = 63;
    private int targetGreen = 118;
    private int targetBlue = 228;
    private int startRed = this.targetRed;
    private int startGreen = this.targetGreen;
    private int startBlue = this.targetBlue;
    public long startTime = System.currentTimeMillis();

    public CauldronBlockEntity(BlockEntityType<? extends CauldronBlockEntity<?>> type, BlockPos pos, BlockState state, int bucketCapacity, int cookDuration) {
        super(type, pos, state, (NonNullList<ItemStack>)NonNullList.create());
        this.posHolder = new SimplePowerPosHolder(pos);
        this.fluidCapacity = bucketCapacity * 1000;
        this.cookDuration = cookDuration;
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        CauldronBlockEntity be = (CauldronBlockEntity)t;
        if (be.firstTick) {
            be.firstTick();
        }
        if (be.isFailed || be.isComplete) {
            return;
        }
        BlockState stateBelow = level.getBlockState(be.worldPosition.below());
        if (!CauldronBlockEntity.providesHeat(stateBelow) || be.fluidAmount != be.fluidCapacity) {
            boolean update = be.cookProgress > 0 || be.warmingUp > 0;
            be.cookProgress = 0;
            be.warmingUp = 0;
            if (!be.inventory.isEmpty()) {
                be.setFailed();
                be.recalculateTargetColour();
                update = true;
            }
            if (update) {
                be.updateBlock();
            }
            return;
        }
        if (be.warmingUp < 80) {
            if (++be.warmingUp == 80) {
                be.updateBlock();
            }
            return;
        }
        if (be.potentialRecipes.size() != 1 || !((CauldronTypeRecipe)be.potentialRecipes.get(0)).fullMatch(ListInput.of((List<ItemStack>)be.inventory))) {
            return;
        }
        if (be.cookProgress < be.cookDuration) {
            ++be.cookProgress;
            be.recalculateTargetColour();
            if (be.cookProgress == 1 || be.cookProgress == be.cookDuration) {
                be.updateBlock();
            }
        } else {
            CauldronTypeRecipe recipe = (CauldronTypeRecipe)be.potentialRecipes.get(0);
            IPowerProvider powerProvider = PowerHelper.tryGetPowerProvider(level, be.getPosHolder());
            if (recipe.getPower() <= 0) {
                be.setComplete();
            } else if (powerProvider != null && powerProvider.tryConsume(recipe.getPower())) {
                be.setComplete();
            } else {
                be.setFailed();
            }
            be.updateBlock();
        }
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        CauldronBlockEntity be = (CauldronBlockEntity)t;
        if (be.firstTick) {
            be.firstTick();
        }
        long time = System.currentTimeMillis() - be.startTime;
        double waterY = be.getWaterY(state);
        if (be.isHot() && Enchanted.RANDOM.nextInt(10) > 2) {
            double dx = (double)pos.getX() + 0.5 + (Math.random() - 0.5) * be.getWaterWidth();
            double dy = (double)pos.getY() + waterY + 0.02;
            double dz = (double)pos.getZ() + 0.5 + (Math.random() - 0.5) * be.getWaterWidth();
            level.addParticle((ParticleOptions)new ColourOptions(EParticleTypes.BOILING.get(), FastColor.ARGB32.color((int)be.getRed(time), (int)be.getGreen(time), (int)be.getBlue(time))), dx, dy, dz, 0.0, 0.0, 0.0);
        }
        if (be.isFailed) {
            return;
        }
        if (!be.isComplete && be.cookProgress > 0 && be.cookProgress < be.cookDuration) {
            be.handleCookParticles(time);
        } else if (be.warmingUp == 80 && be.hasItems && Enchanted.RANDOM.nextInt(10) > 6) {
            double xOffset = 0.5 + (Math.random() - 0.5) * be.getWaterWidth();
            double zOffset = 0.5 + (Math.random() - 0.5) * be.getWaterWidth();
            double dx = (double)be.worldPosition.getX() + xOffset;
            double dy = (double)be.worldPosition.getY() + waterY;
            double dz = (double)be.worldPosition.getZ() + zOffset;
            Vec3 velocity = new Vec3(xOffset, 0.0, zOffset).subtract(0.5, 0.0, 0.5).normalize().scale((1.0 + Math.random()) * 0.06);
            level.addParticle((ParticleOptions)new ColourOptions(EParticleTypes.CAULDRON_BREW.get(), FastColor.ARGB32.color((int)be.getRed(time), (int)be.getGreen(time), (int)be.getBlue(time))), dx, dy, dz, velocity.x, (1.0 + Math.random()) * 0.06, velocity.z);
        }
    }

    public double getWaterY(BlockState state) {
        return this.getWaterStartY(state) + this.getWaterMaxHeight() * (double)this.fluidAmount / (double)this.fluidCapacity;
    }

    public abstract double getWaterStartY(BlockState var1);

    public abstract double getWaterMaxHeight();

    public abstract double getWaterWidth();

    public abstract void handleCookParticles(long var1);

    public int getRed(long time) {
        return (int)Math.round(Mth.lerp((double)Math.min((double)time / 500.0, 1.0), (double)this.startRed, (double)this.targetRed));
    }

    public int getGreen(long time) {
        return (int)Math.round(Mth.lerp((double)Math.min((double)time / 500.0, 1.0), (double)this.startGreen, (double)this.targetGreen));
    }

    public int getBlue(long time) {
        return (int)Math.round(Mth.lerp((double)Math.min((double)time / 500.0, 1.0), (double)this.startBlue, (double)this.targetBlue));
    }

    private void setFailed() {
        this.itemOut = ItemStack.EMPTY;
        this.resetValues();
        this.isFailed = true;
        this.recalculateTargetColour();
    }

    private void setComplete() {
        this.itemOut = ((CauldronTypeRecipe)this.potentialRecipes.get(0)).getResultItem((HolderLookup.Provider)this.level.registryAccess()).copy();
        this.resetValues();
        this.isComplete = true;
        this.recalculateTargetColour();
    }

    public void takeContents(Player player) {
        if (this.level != null && !this.level.isClientSide) {
            if (this.isFailed) {
                this.setWater(0);
                this.level.playSound(null, this.worldPosition, SoundEvents.BUCKET_EMPTY, SoundSource.PLAYERS, 1.0f, 1.0f);
            } else {
                this.fluidAmount -= this.fluidCapacity / ((CauldronTypeRecipe)this.potentialRecipes.getFirst()).getResultItem((HolderLookup.Provider)this.level.registryAccess()).getCount() + 1;
                if (this.fluidAmount < 0) {
                    this.fluidAmount = 0;
                }
            }
            if (!this.itemOut.isEmpty()) {
                if (player != null) {
                    ItemUtils.giveOrDrop(player, this.isFailed ? new ItemStack((ItemLike)Items.WATER_BUCKET) : new ItemStack((ItemLike)this.itemOut.getItem()));
                } else {
                    this.level.addFreshEntity((Entity)new ItemEntity(this.level, (double)this.worldPosition.getX(), (double)(this.worldPosition.getY() + 1), (double)this.worldPosition.getZ(), new ItemStack((ItemLike)this.itemOut.getItem())));
                }
                this.level.playSound(null, this.worldPosition, SoundEvents.BUCKET_EMPTY, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            this.itemOut.shrink(1);
            if (this.itemOut.isEmpty()) {
                this.inventory.clear();
                this.potentialRecipes.clear();
                this.resetValues();
            }
            this.recalculateTargetColour();
            this.updateBlock();
        }
    }

    private void resetValues() {
        this.isFailed = false;
        this.isComplete = false;
        this.cookProgress = 0;
    }

    public void addItem(ItemEntity itemEntity) {
        if (itemEntity.isAlive()) {
            this.inventory.add((Object)itemEntity.getItem());
            this.matchRecipes();
            if (this.potentialRecipes.isEmpty()) {
                if (((Boolean)ServerConfig.INSTANCE.cauldronItemSpoil.get()).booleanValue()) {
                    this.setFailed();
                } else {
                    this.inventory.remove((Object)itemEntity.getItem());
                    this.matchRecipes();
                    return;
                }
            }
            if (this.level != null) {
                this.level.playSound(null, this.worldPosition, SoundEvents.BUCKET_EMPTY, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            itemEntity.kill();
            this.recalculateTargetColour();
            this.updateBlock();
        }
    }

    public boolean addWater(int amount) {
        if (!this.isComplete && !this.isFailed && this.fluidAmount < this.fluidCapacity) {
            this.fluidAmount = Mth.clamp((int)(this.fluidAmount + amount), (int)0, (int)this.fluidCapacity);
            this.setChanged();
            this.recalculateTargetColour();
            this.updateBlock();
            return true;
        }
        return false;
    }

    public boolean removeWater(int amount) {
        if (!this.isComplete && !this.isFailed && this.fluidAmount >= amount) {
            this.fluidAmount -= amount;
            this.setChanged();
            this.updateBlock();
            return true;
        }
        return false;
    }

    public void setWater(int amount) {
        this.fluidAmount = Math.min(amount, this.fluidCapacity);
        this.setChanged();
        this.updateBlock();
    }

    public int getWater() {
        return this.fluidAmount;
    }

    public boolean isFull() {
        return this.fluidAmount >= this.fluidCapacity;
    }

    protected abstract void matchRecipes();

    public static boolean providesHeat(BlockState state) {
        return state.is(ETags.Blocks.HEAT_SOURCES) && (!state.getValues().containsKey(BlockStateProperties.LIT) || (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false);
    }

    private void recalculateTargetColour() {
        if (this.inventory.isEmpty()) {
            this.targetRed = 63;
            this.targetGreen = 118;
            this.targetBlue = 228;
        } else if (this.isComplete) {
            int colour = ((CauldronTypeRecipe)this.potentialRecipes.get(0)).getFinalColour();
            this.targetRed = FastColor.ARGB32.red((int)colour);
            this.targetGreen = FastColor.ARGB32.green((int)colour);
            this.targetBlue = FastColor.ARGB32.blue((int)colour);
        } else if (this.isFailed) {
            this.targetRed = 150;
            this.targetGreen = 100;
            this.targetBlue = 47;
        } else if (!this.potentialRecipes.isEmpty() && this.cookProgress > 0) {
            int colour = ((CauldronTypeRecipe)this.potentialRecipes.get(0)).getCookColour();
            this.targetRed = FastColor.ARGB32.red((int)colour);
            this.targetGreen = FastColor.ARGB32.green((int)colour);
            this.targetBlue = FastColor.ARGB32.blue((int)colour);
        } else {
            this.targetRed = Enchanted.RANDOM.nextInt(80);
            this.targetGreen = Enchanted.RANDOM.nextInt(80);
            this.targetBlue = Enchanted.RANDOM.nextInt(80);
        }
    }

    public boolean isHot() {
        return this.warmingUp == 80;
    }

    protected void setPotentialRecipes(List<RecipeHolder<T>> potentialRecipes) {
        this.potentialRecipes.clear();
        for (RecipeHolder<T> holder : potentialRecipes) {
            this.potentialRecipes.add((CauldronTypeRecipe)holder.value());
        }
    }

    public void firstTick() {
        this.firstTick = false;
        if (!this.level.isClientSide) {
            this.matchRecipes();
        } else {
            this.startRed = this.targetRed;
            this.startGreen = this.targetGreen;
            this.startBlue = this.targetBlue;
            CauldronClientHandler.startSound(this);
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void saveBase(CompoundTag nbt) {
        nbt.putInt("waterAmount", this.fluidAmount);
        nbt.putInt("targetRed", this.targetRed);
        nbt.putInt("targetGreen", this.targetGreen);
        nbt.putInt("targetBlue", this.targetBlue);
        nbt.putBoolean("isFailed", this.isFailed);
        nbt.putBoolean("isComplete", this.isComplete);
        nbt.putInt("warmingUp", this.warmingUp);
        nbt.putInt("cookProgress", this.cookProgress);
    }

    public void loadBase(CompoundTag nbt) {
        this.setWater(nbt.getInt("waterAmount"));
        this.isFailed = nbt.getBoolean("isFailed");
        this.isComplete = nbt.getBoolean("isComplete");
        this.warmingUp = nbt.getInt("warmingUp");
        this.cookProgress = nbt.getInt("cookProgress");
        int tr = nbt.getInt("targetRed");
        int tg = nbt.getInt("targetGreen");
        int tb = nbt.getInt("targetBlue");
        if (tr != this.targetRed || tg != this.targetGreen || tb != this.targetBlue) {
            this.updateTargetColour(tr, tg, tb);
        }
    }

    @Override
    public void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.saveBase(tag);
        ContainerHelper.saveAllItems((CompoundTag)tag, (NonNullList)this.inventory, (HolderLookup.Provider)registries);
        if (this.itemOut != ItemStack.EMPTY) {
            CompoundTag itemNbt = new CompoundTag();
            itemNbt.putString("item", BuiltInRegistries.ITEM.getKey((Object)this.itemOut.getItem()).toString());
            itemNbt.putInt("count", this.itemOut.getCount());
            tag.put("itemOut", (Tag)itemNbt);
        }
        tag.put("posHolder", (Tag)this.posHolder.serialize());
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.loadBase(tag);
        if (tag.contains("posHolder")) {
            this.posHolder.deserialize(tag.getCompound("posHolder"));
        }
        if (tag.contains("Items")) {
            ListTag list = tag.getList("Items", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag compoundnbt = list.getCompound(i);
                this.inventory.add((Object)ItemStack.parse((HolderLookup.Provider)registries, (Tag)compoundnbt).orElse(ItemStack.EMPTY));
            }
            if (tag.contains("itemOut")) {
                CompoundTag itemNbt = (CompoundTag)tag.get("itemOut");
                this.itemOut = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)itemNbt.getString("item"))), itemNbt.getInt("count"));
            }
        } else if (tag.contains("hasItems")) {
            this.hasItems = tag.getBoolean("hasItems");
        }
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag nbt = new CompoundTag();
        this.saveBase(nbt);
        nbt.putBoolean("hasItems", !this.inventory.isEmpty());
        return nbt;
    }

    public void updateTargetColour(int red, int green, int blue) {
        long time = System.currentTimeMillis();
        long timeSince = time - this.startTime;
        this.startRed = this.getRed(timeSince);
        this.startGreen = this.getGreen(timeSince);
        this.startBlue = this.getBlue(timeSince);
        this.targetRed = red;
        this.targetGreen = green;
        this.targetBlue = blue;
        this.startTime = time;
    }

    @Override
    public NonNullList<ItemStack> getDroppableInventory() {
        return NonNullList.create();
    }

    @Override
    @NotNull
    public IPowerConsumer.IPowerPosHolder getPosHolder() {
        return this.posHolder;
    }

    public int[] getSlotsForFace(Direction direction) {
        return new int[0];
    }

    public boolean canPlaceItemThroughFace(int i, ItemStack itemStack, @Nullable Direction direction) {
        return false;
    }

    public boolean canTakeItemThroughFace(int i, ItemStack itemStack, Direction direction) {
        return false;
    }
}

