/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.blocks.entity;

import com.mojang.serialization.DynamicOps;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.blocks.entity.EBlockEntityTypes;
import net.favouriteless.enchanted.common.items.component.EntityRefData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class BloodPoppyBlockEntity
extends BlockEntity {
    private EntityRefData data = null;

    public BloodPoppyBlockEntity(BlockPos pos, BlockState state) {
        super(EBlockEntityTypes.BLOOD_POPPY.get(), pos, state);
    }

    public void setTaglockData(EntityRefData data) {
        this.data = data;
    }

    public EntityRefData getTaglockData() {
        return this.data;
    }

    public void reset() {
        this.data = null;
    }

    protected void saveAdditional(CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        if (this.data != null) {
            tag.put("taglockData", (Tag)EntityRefData.CODEC.encode((Object)this.data, (DynamicOps)NbtOps.INSTANCE, (Object)new CompoundTag()).getOrThrow());
        }
    }

    protected void loadAdditional(CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        if (tag.contains("taglockData")) {
            this.data = EntityRefData.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("taglockData")).resultOrPartial(e -> Enchanted.LOG.error("Tried to load invalid taglock data: '{}'", e)).orElse(null);
        }
    }
}

