/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.blocks.entity;

import net.favouriteless.enchanted.api.power.IPowerConsumer;
import net.favouriteless.enchanted.api.power.IPowerProvider;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.ServerConfig;
import net.favouriteless.enchanted.common.altar.AltarBlockData;
import net.favouriteless.enchanted.common.altar.AltarUpgradeData;
import net.favouriteless.enchanted.common.blocks.altar.AltarBlock;
import net.favouriteless.enchanted.common.blocks.entity.EBlockEntityTypes;
import net.favouriteless.enchanted.common.menus.AltarMenu;
import net.favouriteless.enchanted.common.stateobservers.AltarStateObserver;
import net.favouriteless.stateobserver.api.StateObserver;
import net.favouriteless.stateobserver.api.StateObserverManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class AltarBlockEntity
extends BlockEntity
implements MenuProvider,
IPowerProvider {
    private final double rechargeRate;
    private final AltarBlockData altarBlockData;
    private final AltarUpgradeData altarUpgradeData;
    private double rechargeMultiplier;
    private double powerMultiplier;
    private double maxPower;
    private double currentPower;
    private final ContainerData fields;
    private AltarStateObserver stateObserver;
    private boolean facingX;
    private Vec3 centerPos;
    private boolean firstLoad;
    private int ticksAlive;
    private boolean firstTick;

    public AltarBlockEntity(BlockPos pos, BlockState state) {
        super(EBlockEntityTypes.ALTAR.get(), pos, state);
        this.rechargeRate = (Double)ServerConfig.INSTANCE.altarBaseRecharge.get();
        this.altarBlockData = new AltarBlockData();
        this.altarUpgradeData = new AltarUpgradeData();
        this.rechargeMultiplier = 1.0;
        this.powerMultiplier = 1.0;
        this.fields = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> (int)Math.round(AltarBlockEntity.this.currentPower);
                    case 1 -> (int)Math.round(AltarBlockEntity.this.maxPower);
                    case 2 -> (int)Math.round(AltarBlockEntity.this.rechargeMultiplier);
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        AltarBlockEntity.this.currentPower = value;
                    }
                    case 1: {
                        AltarBlockEntity.this.maxPower = value;
                    }
                    case 2: {
                        AltarBlockEntity.this.rechargeMultiplier = value;
                    }
                }
            }

            public int getCount() {
                return 3;
            }
        };
        this.stateObserver = null;
        this.firstLoad = true;
        this.ticksAlive = 0;
        this.firstTick = true;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, AltarBlockEntity be) {
        if (be.firstTick) {
            be.firstTick();
        }
        if (be.ticksAlive % 20 == 0) {
            be.stateObserver.checkChanges();
        }
        if (be.currentPower <= be.maxPower) {
            be.currentPower += be.rechargeRate * be.rechargeMultiplier;
        }
        if (be.currentPower > be.maxPower) {
            be.currentPower = be.maxPower;
        }
        ++be.ticksAlive;
    }

    public void firstTick() {
        if (this.stateObserver == null) {
            this.stateObserver = (AltarStateObserver)StateObserverManager.get().getObserver(this.level, this.worldPosition, AltarStateObserver.class);
        }
        if (this.stateObserver == null) {
            int range = (Integer)ServerConfig.INSTANCE.altarRange.get();
            this.stateObserver = (AltarStateObserver)StateObserverManager.get().addObserver((StateObserver)new AltarStateObserver(this.level, this.worldPosition, range + 4, range + 4, range + 4));
        }
        this.facingX = (Boolean)this.level.getBlockState(this.worldPosition).getValue((Property)AltarBlock.FACING_X);
        Vec3 vec3 = this.centerPos = this.facingX ? Vec3.atLowerCornerOf((Vec3i)this.worldPosition).add(1.0, 0.0, 0.5) : Vec3.atLowerCornerOf((Vec3i)this.worldPosition).add(0.5, 0.0, 1.0);
        if (this.firstLoad) {
            this.recalculateAll();
        }
        this.firstTick = false;
    }

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.putDouble("currentPower", this.currentPower);
        nbt.putDouble("maxPower", this.maxPower);
        nbt.putDouble("powerMultiplier", this.powerMultiplier);
        nbt.putDouble("rechargeMultiplier", this.rechargeMultiplier);
        nbt.put("blockData", (Tag)this.altarBlockData.save());
        nbt.put("upgradeData", (Tag)this.altarUpgradeData.save(this.level));
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        this.setMaxPower(nbt.getDouble("maxPower"));
        this.currentPower = nbt.getDouble("currentPower");
        this.powerMultiplier = nbt.getDouble("powerMultiplier");
        this.rechargeMultiplier = nbt.getDouble("rechargeMultiplier");
        if (nbt.contains("blockData") && nbt.contains("upgradeData")) {
            this.altarBlockData.load(nbt.getCompound("blockData"));
            this.altarUpgradeData.load(nbt.getCompound("upgradeData"));
        } else {
            Enchanted.LOG.error("Failed to load power block data for altar at {}", (Object)this.getBlockPos().toShortString());
        }
        this.firstLoad = false;
    }

    private void recalculateAll() {
        this.recalculateUpgrades();
        this.recalculateBlocks();
    }

    private void recalculateUpgrades() {
        if (this.level != null && !this.level.isClientSide) {
            BlockPos minPos = this.worldPosition.above();
            BlockPos maxPos = this.facingX ? minPos.offset(2, 0, 1) : minPos.offset(1, 0, 2);
            this.altarUpgradeData.reset();
            for (BlockPos pos : BlockPos.betweenClosed((BlockPos)minPos, (BlockPos)maxPos)) {
                this.altarUpgradeData.addBlock(this.level, this.level.getBlockState(pos).getBlock());
            }
            this.powerMultiplier = this.altarUpgradeData.calculatePowerMultiplier(this.level);
            this.rechargeMultiplier = this.altarUpgradeData.calculateRechargeMultiplier(this.level);
            this.setChanged();
        }
    }

    private void recalculateBlocks() {
        if (this.level != null && !this.level.isClientSide) {
            int range = (Integer)ServerConfig.INSTANCE.altarRange.get();
            BlockPos startingPos = this.facingX ? BlockPos.containing((Position)this.centerPos.add((double)(-(range + 4)), (double)(-(range + 2)), (double)(-(range + 2)))) : BlockPos.containing((Position)this.centerPos.add((double)(-(range + 2)), (double)(-(range + 2)), (double)(-(range + 4))));
            this.altarBlockData.reset();
            for (int x = 0; x < (range + 2) * 2; ++x) {
                for (int y = 0; y < (range + 2) * 2; ++y) {
                    for (int z = 0; z < (range + 2) * 2; ++z) {
                        BlockPos currentPos = startingPos.offset(x, y, z);
                        if (!this.posWithinRange(currentPos, range)) continue;
                        BlockEntity blockEntity = this.level.getBlockEntity(currentPos);
                        if (blockEntity instanceof IPowerConsumer) {
                            IPowerConsumer consumer = (IPowerConsumer)blockEntity;
                            consumer.getPosHolder().add(this.worldPosition);
                        }
                        this.addBlock(this.level.getBlockState(currentPos).getBlock());
                    }
                }
            }
        }
    }

    public boolean posWithinRange(BlockPos pos, int range) {
        if (this.level != null) {
            double rx = this.facingX ? (double)(range + 1) : (double)range;
            double rz = this.facingX ? (double)range : (double)(range + 1);
            double dx = (double)pos.getX() - this.centerPos.x;
            double dy = (double)pos.getY() - this.centerPos.y;
            double dz = (double)pos.getZ() - this.centerPos.z;
            return dx * dx / (rx * rx) + dy * dy / (double)(range * range) + dz * dz / (rz * rz) <= 1.0;
        }
        return false;
    }

    public boolean posIsUpgrade(BlockPos pos) {
        if (this.level != null) {
            int zMax;
            int xMax;
            if (this.facingX) {
                xMax = 2;
                zMax = 1;
            } else {
                xMax = 1;
                zMax = 2;
            }
            int xOffset = pos.getX() - this.worldPosition.getX();
            int zOffset = pos.getZ() - this.worldPosition.getZ();
            boolean withinX = xOffset >= 0 && xOffset <= xMax;
            boolean withinZ = zOffset >= 0 && zOffset <= zMax;
            return pos.getY() == this.worldPosition.getY() + 1 && withinX && withinZ;
        }
        return false;
    }

    public void setMaxPower(double power) {
        this.maxPower = power;
        if (this.currentPower > this.maxPower) {
            this.currentPower = this.maxPower;
        }
        this.setChanged();
    }

    public void addBlock(Block block) {
        this.setMaxPower(this.maxPower + (double)this.altarBlockData.addBlock(this.level, block) * this.powerMultiplier);
        this.setChanged();
    }

    public void removeBlock(Block block) {
        this.setMaxPower(this.maxPower - (double)this.altarBlockData.removeBlock(this.level, block) * this.powerMultiplier);
        this.setChanged();
    }

    public void addUpgrade(Block block) {
        if (this.altarUpgradeData.addBlock(this.level, block)) {
            double newPowerMultiplier = this.altarUpgradeData.calculatePowerMultiplier(this.level);
            if (newPowerMultiplier != this.powerMultiplier) {
                this.powerMultiplier = newPowerMultiplier;
                this.setMaxPower(this.altarBlockData.calculatePower(this.level, this.powerMultiplier));
            }
            this.rechargeMultiplier = this.altarUpgradeData.calculateRechargeMultiplier(this.level);
            this.setChanged();
        }
    }

    public void removeUpgrade(Block block) {
        if (this.altarUpgradeData.removeBlock(this.level, block)) {
            double newPowerMultiplier = this.altarUpgradeData.calculatePowerMultiplier(this.level);
            if (newPowerMultiplier != this.powerMultiplier) {
                this.powerMultiplier = newPowerMultiplier;
                this.setMaxPower(this.altarBlockData.calculatePower(this.level, this.powerMultiplier));
            }
            this.rechargeMultiplier = this.altarUpgradeData.calculateRechargeMultiplier(this.level);
            this.setChanged();
        }
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.enchanted.altar");
    }

    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new AltarMenu(id, this, this.fields);
    }

    @Override
    public boolean tryConsume(double amount) {
        if (this.currentPower > amount) {
            this.currentPower -= amount;
            return true;
        }
        return false;
    }
}

