/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.blocks.crops;

import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.blocks.crops.CropBlockAgeFive;
import net.favouriteless.enchanted.common.entities.Mandrake;
import net.favouriteless.enchanted.common.init.EBlocks;
import net.favouriteless.enchanted.common.init.EEntityTypes;
import net.favouriteless.enchanted.common.init.EItems;
import net.minecraft.core.BlockPos;
import net.minecraft.stats.Stats;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class MandrakeBlock
extends CropBlockAgeFive {
    public MandrakeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected ItemLike getBaseSeedId() {
        return (ItemLike)EItems.MANDRAKE_SEEDS.get();
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, BlockEntity blockEntity, ItemStack stack) {
        player.awardStat(Stats.BLOCK_MINED.get((Object)this));
        player.causeFoodExhaustion(0.005f);
        if (!level.isClientSide() && level.getDifficulty() != Difficulty.PEACEFUL && state.is((Block)EBlocks.MANDRAKE.get()) && (Integer)state.getValue((Property)AGE_FIVE) == 4) {
            if (level.isDay()) {
                MandrakeBlock.spawnMandrake(level, pos);
                return;
            }
            if (Enchanted.RANDOM.nextInt(5) == 0) {
                MandrakeBlock.spawnMandrake(level, pos);
                return;
            }
        }
        MandrakeBlock.dropResources((BlockState)state, (Level)level, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)player, (ItemStack)stack);
    }

    public static void spawnMandrake(Level level, BlockPos pos) {
        Mandrake entity = (Mandrake)EEntityTypes.MANDRAKE.get().create(level);
        entity.moveTo((double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, 0.0f, 0.0f);
        level.addFreshEntity((Entity)entity);
    }
}

