/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.blocks.crops;

import net.favouriteless.enchanted.common.blocks.crops.AbstractSpreadingBlock;
import net.favouriteless.enchanted.common.init.ETags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EmberMossBlock
extends AbstractSpreadingBlock {
    public EmberMossBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return !level.isEmptyBlock(pos.below()) && level.getBlockState(pos.below()).isFaceSturdy((BlockGetter)level, pos.below(), Direction.UP);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        entity.setRemainingFireTicks(20);
        super.entityInside(state, level, pos, entity);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0);
    }

    @Override
    public boolean canSpreadOn(BlockState block) {
        return block.is(ETags.Blocks.EMBER_MOSS_SPREADS_ON);
    }
}

