/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.blocks.crops;

import net.favouriteless.enchanted.common.blocks.entity.BloodPoppyBlockEntity;
import net.favouriteless.enchanted.common.items.component.EntityRefData;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BloodPoppyBlock
extends FlowerBlock
implements EntityBlock {
    public static final BooleanProperty FILLED = BooleanProperty.create((String)"filled");
    private static final VoxelShape SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0);

    public BloodPoppyBlock(BlockBehaviour.Properties properties) {
        super(MobEffects.WITHER, 1200.0f, properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FILLED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FILLED});
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (level.isClientSide || ((Boolean)state.getValue((Property)FILLED)).booleanValue() || !(entity instanceof LivingEntity)) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BloodPoppyBlockEntity) {
            BloodPoppyBlockEntity poppy = (BloodPoppyBlockEntity)blockEntity;
            poppy.setTaglockData(EntityRefData.of(entity.getUUID(), entity.getDisplayName().getString()));
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)FILLED, (Comparable)Boolean.valueOf(true)));
        }
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public static void reset(Level level, BlockPos pos) {
        if (level.isClientSide) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BloodPoppyBlockEntity) {
            BloodPoppyBlockEntity poppy = (BloodPoppyBlockEntity)blockEntity;
            BlockState state = level.getBlockState(pos);
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)FILLED, (Comparable)Boolean.valueOf(false)));
            poppy.reset();
        }
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BloodPoppyBlockEntity(pos, state);
    }
}

