/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.blocks.crops;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractSpreadingBlock
extends Block {
    public AbstractSpreadingBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!this.canSpreadOn(level.getBlockState(pos.below()))) {
            return;
        }
        if (random.nextInt(25) != 0) {
            return;
        }
        int max = 5;
        for (BlockPos p : BlockPos.betweenClosed((BlockPos)pos.offset(-4, -1, -4), (BlockPos)pos.offset(4, 1, 4))) {
            if (!level.getBlockState(p).is((Block)this) || --max > 0) continue;
            return;
        }
        for (int k = 0; k < 4; ++k) {
            BlockPos p;
            p = pos.offset(random.nextInt(3) - 1, random.nextInt(2) - random.nextInt(2), random.nextInt(3) - 1);
            if (!level.isEmptyBlock(p) || !state.canSurvive((LevelReader)level, p)) continue;
            level.setBlockAndUpdate(p, state);
            break;
        }
    }

    public boolean canSpreadOn(BlockState block) {
        return true;
    }
}

