/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.blocks.chalk;

import java.util.Random;
import net.favouriteless.enchanted.common.blocks.chalk.AbstractChalkBlock;
import net.favouriteless.enchanted.common.blocks.entity.EBlockEntityTypes;
import net.favouriteless.enchanted.common.blocks.entity.GoldChalkBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class GoldChalkBlock
extends AbstractChalkBlock
implements EntityBlock {
    public static final IntegerProperty GLYPH = IntegerProperty.create((String)"glyph", (int)0, (int)3);
    public static final Random random = new Random();

    public GoldChalkBlock() {
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)GLYPH, (Comparable)Integer.valueOf(0)));
    }

    @Override
    public BlockState getRandomState() {
        return (BlockState)this.defaultBlockState().setValue((Property)GLYPH, (Comparable)Integer.valueOf(random.nextInt(4)));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new GoldChalkBlockEntity(pos, state);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state != newState) {
            // empty if block
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{GLYPH});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.getRandomState();
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof GoldChalkBlockEntity) {
            GoldChalkBlockEntity be = (GoldChalkBlockEntity)blockEntity;
            be.use(level, pos, player);
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return !level.isClientSide ? GoldChalkBlock.createTickerHelper(type, EBlockEntityTypes.GOLD_CHALK.get(), GoldChalkBlockEntity::serverTick) : null;
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> serverType, BlockEntityType<E> clientType, BlockEntityTicker<? super E> ticker) {
        return clientType == serverType ? ticker : null;
    }
}

