/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.blocks.chalk;

import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.blocks.chalk.AbstractChalkBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class ChalkCircleBlock
extends AbstractChalkBlock {
    public static final IntegerProperty GLYPH = IntegerProperty.create((String)"glyph", (int)0, (int)47);
    private final SimpleParticleType particleType;

    public ChalkCircleBlock(SimpleParticleType particleType) {
        this.particleType = particleType;
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)GLYPH, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{GLYPH});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.getRandomState();
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (this.particleType != null && random.nextInt(6) == 1) {
            double dx = random.nextDouble();
            double dz = random.nextDouble();
            level.addParticle((ParticleOptions)this.particleType, (double)pos.getX() + dx, (double)pos.getY() + 0.1, (double)pos.getZ() + dz, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public BlockState getRandomState() {
        return (BlockState)this.defaultBlockState().setValue((Property)GLYPH, (Comparable)Integer.valueOf(Enchanted.RANDOM.nextInt(48)));
    }
}

