/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.blocks.cauldrons;

import net.favouriteless.enchanted.common.blocks.cauldrons.CauldronBlockBase;
import net.favouriteless.enchanted.common.blocks.entity.KettleBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class KettleBlock
extends CauldronBlockBase {
    public static DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static IntegerProperty TYPE = IntegerProperty.create((String)"type", (int)0, (int)2);
    public static final VoxelShape TYPE_1_SHAPE = Shapes.box((double)0.1875, (double)0.125, (double)0.1875, (double)0.8125, (double)0.5, (double)0.8125);
    public static final VoxelShape TYPE_2_SHAPE = Shapes.box((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)0.375, (double)0.8125);

    public KettleBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new KettleBlockEntity(pos, state);
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return (Integer)pState.getValue((Property)TYPE) == 1 ? TYPE_1_SHAPE : TYPE_2_SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, TYPE});
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean pIsMoving) {
        BlockState newState = this.getKettleState(world, pos, (Direction)state.getValue((Property)FACING));
        if (state != newState) {
            world.setBlock(pos, newState, 2);
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return this.getKettleState(pContext.getLevel(), pContext.getClickedPos(), pContext.getHorizontalDirection().getOpposite());
    }

    public BlockState getKettleState(Level world, BlockPos pos, @Nullable Direction facing) {
        if (facing == null) {
            facing = Direction.NORTH;
        }
        int type = 0;
        Direction left = facing.getCounterClockWise();
        Direction right = facing.getClockWise();
        if (world.getBlockState(pos.above()).isFaceSturdy((BlockGetter)world, pos.above(), Direction.DOWN)) {
            type = 1;
        } else if (world.getBlockState(pos.relative(left)).isFaceSturdy((BlockGetter)world, pos.relative(left), right, SupportType.CENTER) && world.getBlockState(pos.relative(right)).isFaceSturdy((BlockGetter)world, pos.relative(right), left, SupportType.CENTER) || world.getBlockState(pos.relative(left)).getBlock() instanceof WallBlock && world.getBlockState(pos.relative(right)).getBlock() instanceof WallBlock) {
            type = 2;
        } else if (world.getBlockState(pos.relative(facing)).isFaceSturdy((BlockGetter)world, pos.relative(facing), facing.getOpposite(), SupportType.CENTER) && world.getBlockState(pos.relative(facing.getOpposite())).isFaceSturdy((BlockGetter)world, pos.relative(facing.getOpposite()), facing, SupportType.CENTER) || world.getBlockState(pos.relative(facing)).getBlock() instanceof WallBlock && world.getBlockState(pos.relative(facing.getOpposite())).getBlock() instanceof WallBlock) {
            type = 2;
            facing = facing.getClockWise();
        }
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing)).setValue((Property)TYPE, (Comparable)Integer.valueOf(type));
    }
}

