/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.blocks.altar;

import net.favouriteless.enchanted.common.init.EBlocks;
import net.favouriteless.enchanted.common.init.EItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Vector3f;

public class ChaliceBlock
extends Block {
    private final boolean isFilled;

    public ChaliceBlock(boolean filled, BlockBehaviour.Properties properties) {
        super(properties);
        this.isFilled = filled;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (state.is((Block)EBlocks.CHALICE.get()) && player.getItemInHand(hand).getItem() == EItems.REDSTONE_SOUP.get()) {
            if (!level.isClientSide) {
                level.playSound(null, pos, SoundEvents.FISHING_BOBBER_SPLASH, SoundSource.BLOCKS, 0.4f, 1.0f);
                level.setBlockAndUpdate(pos, EBlocks.CHALICE_FILLED.get().defaultBlockState());
                player.getItemInHand(hand).shrink(1);
                return ItemInteractionResult.CONSUME;
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.box((double)0.34375, (double)0.0, (double)0.34375, (double)0.65625, (double)0.4375, (double)0.65625);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (this.isFilled) {
            double x = (double)pos.getX() + 0.4 + random.nextDouble() * 0.2;
            double y = (double)pos.getY() + 0.5;
            double z = (double)pos.getZ() + 0.4 + random.nextDouble() * 0.2;
            level.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(3.6f, 0.2f, 0.0f), 0.6f), x, y, z, 0.0, 0.0, 0.0);
        }
    }
}

