/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.blocks.altar;

import com.mojang.serialization.MapCodec;
import net.favouriteless.enchanted.common.blocks.entity.AltarBlockEntity;
import net.favouriteless.enchanted.common.blocks.entity.EBlockEntityTypes;
import net.favouriteless.enchanted.common.multiblock.MultiBlockTools;
import net.favouriteless.enchanted.common.multiblock.altar.AltarMultiBlock;
import net.favouriteless.enchanted.common.multiblock.altar.AltarPartIndex;
import net.favouriteless.enchanted.platform.CommonServices;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class AltarBlock
extends BaseEntityBlock {
    public static final EnumProperty<AltarPartIndex> FORMED = EnumProperty.create((String)"formed", AltarPartIndex.class);
    public static final BooleanProperty FACING_X = BooleanProperty.create((String)"facing_x");
    public final MapCodec<AltarBlock> codec = AltarBlock.simpleCodec(AltarBlock::new);

    public AltarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(FORMED, (Comparable)((Object)AltarPartIndex.UNFORMED))).setValue((Property)FACING_X, (Comparable)Boolean.valueOf(true)));
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (!world.isClientSide()) {
            MultiBlockTools.formMultiblock(AltarMultiBlock.INSTANCE, world, pos);
        }
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!world.isClientSide() && state != newState && state.getValue(FORMED) != AltarPartIndex.UNFORMED) {
            MultiBlockTools.breakMultiblock(AltarMultiBlock.INSTANCE, world, pos, state);
        }
        super.onRemove(state, world, pos, newState, isMoving);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FORMED});
        builder.add(new Property[]{FACING_X});
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (state.getValue(FORMED) != AltarPartIndex.UNFORMED) {
            if (!level.isClientSide) {
                BlockEntity blockEntity;
                BlockPos cornerPos = AltarMultiBlock.INSTANCE.getBottomLowerLeft(level, pos, state);
                BlockState cornerState = level.getBlockState(cornerPos);
                if (cornerState.getValue(FORMED) == AltarPartIndex.P000 && (blockEntity = level.getBlockEntity(cornerPos)) instanceof AltarBlockEntity) {
                    AltarBlockEntity be = (AltarBlockEntity)blockEntity;
                    CommonServices.PLATFORM.openMenu((ServerPlayer)player, be, be.getBlockPos(), BlockPos.STREAM_CODEC);
                }
                return InteractionResult.CONSUME;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return state.getValue(FORMED) == AltarPartIndex.P000 ? new AltarBlockEntity(pos, state) : null;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return this.codec;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? null : AltarBlock.createTickerHelper(type, EBlockEntityTypes.ALTAR.get(), AltarBlockEntity::serverTick);
    }
}

