/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.blocks;

import com.mojang.serialization.MapCodec;
import net.favouriteless.enchanted.common.blocks.SimpleContainerBlockBase;
import net.favouriteless.enchanted.common.blocks.entity.EBlockEntityTypes;
import net.favouriteless.enchanted.common.blocks.entity.SpinningWheelBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SpinningWheelBlock
extends SimpleContainerBlockBase {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final VoxelShape X_SHAPE = Shapes.box((double)0.0625, (double)0.0, (double)0.3125, (double)0.9375, (double)0.8125, (double)0.6875);
    public static final VoxelShape Z_SHAPE = Shapes.box((double)0.3125, (double)0.0, (double)0.0625, (double)0.6875, (double)0.8125, (double)0.9375);
    private final MapCodec<SpinningWheelBlock> codec = SpinningWheelBlock.simpleCodec(SpinningWheelBlock::new);

    public SpinningWheelBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return this.codec;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SpinningWheelBlockEntity(pos, state);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return ((Direction)pState.getValue((Property)FACING)).getAxis() == Direction.Axis.X ? Z_SHAPE : X_SHAPE;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? SpinningWheelBlock.createTickerHelper(type, EBlockEntityTypes.SPINNING_WHEEL.get(), SpinningWheelBlockEntity::clientTick) : SpinningWheelBlock.createTickerHelper(type, EBlockEntityTypes.SPINNING_WHEEL.get(), SpinningWheelBlockEntity::serverTick);
    }
}

