/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.blocks;

import net.favouriteless.enchanted.common.blocks.entity.ContainerBlockEntityBase;
import net.favouriteless.enchanted.platform.CommonServices;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleContainerBlockBase
extends BaseEntityBlock {
    public SimpleContainerBlockBase(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof MenuProvider) {
            MenuProvider mp = (MenuProvider)blockEntity;
            CommonServices.PLATFORM.openMenu((ServerPlayer)player, mp, pos, BlockPos.STREAM_CODEC);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public void onRemove(BlockState state, Level level, BlockPos blockPos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity blockEntity = level.getBlockEntity(blockPos);
            if (blockEntity instanceof ContainerBlockEntityBase) {
                ContainerBlockEntityBase be = (ContainerBlockEntityBase)blockEntity;
                Containers.dropContents((Level)level, (BlockPos)blockPos, be.getDroppableInventory());
            }
            super.onRemove(state, level, blockPos, newState, isMoving);
        }
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity livingEntity, ItemStack stack) {
        BlockEntity blockEntity;
        if (stack.has(DataComponents.CUSTOM_NAME) && (blockEntity = level.getBlockEntity(pos)) instanceof ContainerBlockEntityBase) {
            ContainerBlockEntityBase be = (ContainerBlockEntityBase)blockEntity;
            be.setCustomName(stack.getHoverName());
        }
    }
}

