/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.blocks;

import net.favouriteless.enchanted.common.blocks.WitchOvenBlock;
import net.favouriteless.enchanted.common.init.EBlocks;
import net.favouriteless.enchanted.common.init.EItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FumeFunnelBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final IntegerProperty TYPE = IntegerProperty.create((String)"type", (int)0, (int)3);
    private static final VoxelShape SHAPE = Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.875, (double)0.9375);
    private static final VoxelShape SHAPE_TOP_NORTH = Shapes.box((double)0.3125, (double)0.0, (double)0.5, (double)0.6875, (double)0.5, (double)0.875);
    private static final VoxelShape SHAPE_TOP_SOUTH = Shapes.box((double)0.3125, (double)0.0, (double)0.125, (double)0.6875, (double)0.5, (double)0.5);
    private static final VoxelShape SHAPE_TOP_EAST = Shapes.box((double)0.125, (double)0.0, (double)0.3125, (double)0.5, (double)0.5, (double)0.6875);
    private static final VoxelShape SHAPE_TOP_WEST = Shapes.box((double)0.5, (double)0.0, (double)0.3125, (double)0.875, (double)0.5, (double)0.6875);
    private final double byproductChance;

    public FumeFunnelBlock(double byproductChance, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)TYPE, (Comparable)Integer.valueOf(0)));
        this.byproductChance = byproductChance;
    }

    public double getByproductChance() {
        return this.byproductChance;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is(EItems.FUME_FILTER.get())) {
            if (!level.isClientSide) {
                Direction facing = (Direction)state.getValue((Property)FACING);
                int type = (Integer)state.getValue((Property)TYPE);
                boolean lit = (Boolean)state.getValue((Property)LIT);
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)((BlockState)EBlocks.FUME_FUNNEL_FILTERED.get().defaultBlockState().setValue((Property)TYPE, (Comparable)Integer.valueOf(type))).setValue((Property)FACING, (Comparable)facing)).setValue((Property)LIT, (Comparable)Boolean.valueOf(lit)));
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        VoxelShape voxelShape;
        if ((Integer)state.getValue((Property)TYPE) == 1) {
            switch ((Direction)state.getValue((Property)FACING)) {
                default: {
                    voxelShape = SHAPE_TOP_NORTH;
                    break;
                }
                case SOUTH: {
                    voxelShape = SHAPE_TOP_SOUTH;
                    break;
                }
                case EAST: {
                    voxelShape = SHAPE_TOP_EAST;
                    break;
                }
                case WEST: {
                    voxelShape = SHAPE_TOP_WEST;
                    break;
                }
            }
        } else {
            voxelShape = SHAPE;
        }
        return voxelShape;
    }

    public float getShadeBrightness(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1.0f;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
        return this.getWitchOvenState(state, (LevelAccessor)context.getLevel(), context.getClickedPos());
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return this.getWitchOvenState(stateIn, level, currentPos);
    }

    public BlockState getWitchOvenState(BlockState state, LevelAccessor world, BlockPos pos) {
        int type = 3;
        boolean lit = false;
        for (Direction dir : Direction.values()) {
            BlockState ovenState;
            if (dir == Direction.UP || !(ovenState = world.getBlockState(pos.offset(dir.getNormal()))).is((Block)EBlocks.WITCH_OVEN.get())) continue;
            if (dir == ovenState.getValue((Property)WitchOvenBlock.FACING) || dir == ((Direction)ovenState.getValue((Property)WitchOvenBlock.FACING)).getOpposite()) break;
            state = (BlockState)state.setValue((Property)FACING, (Comparable)((Direction)ovenState.getValue((Property)WitchOvenBlock.FACING)));
            lit = (Boolean)ovenState.getValue((Property)WitchOvenBlock.LIT);
            if (dir == Direction.DOWN) {
                type = 1;
                break;
            }
            if (dir == ((Direction)state.getValue((Property)FACING)).getClockWise()) {
                type = 2;
                break;
            }
            if (dir != ((Direction)state.getValue((Property)FACING)).getCounterClockWise()) break;
            type = 0;
            break;
        }
        return (BlockState)((BlockState)state.setValue((Property)TYPE, (Comparable)Integer.valueOf(type))).setValue((Property)LIT, (Comparable)Boolean.valueOf(lit));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, LIT, TYPE});
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue() && (Integer)state.getValue((Property)TYPE) != 1 && random.nextInt(8) == 0) {
            double d0 = (double)pos.getX() + 0.5;
            double d1 = pos.getY();
            double d2 = (double)pos.getZ() + 0.5;
            if (random.nextDouble() < 0.1) {
                level.playLocalSound(d0, d1, d2, SoundEvents.FURNACE_FIRE_CRACKLE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            Direction direction = (Direction)state.getValue((Property)FACING);
            Direction.Axis axis = direction.getAxis();
            double d4 = random.nextDouble() * 0.6 - 0.3;
            double d5 = axis == Direction.Axis.X ? (double)direction.getStepX() * 0.49 : d4;
            double d6 = random.nextDouble() * 6.0 / 16.0;
            double d7 = axis == Direction.Axis.Z ? (double)direction.getStepZ() * 0.49 : d4;
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
            level.addParticle((ParticleOptions)ParticleTypes.FLAME, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
        }
    }
}

