/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.altar;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.favouriteless.enchanted.api.power.IPowerConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;

public class SimplePowerPosHolder
implements IPowerConsumer.IPowerPosHolder {
    private List<BlockPos> altars = new ArrayList<BlockPos>();
    private final BlockPos pos;

    public SimplePowerPosHolder(BlockPos pos) {
        this.pos = pos;
    }

    @Override
    @NotNull
    public List<BlockPos> getPositions() {
        return this.altars;
    }

    @Override
    public void remove(BlockPos altarPos) {
        this.altars.remove(altarPos);
    }

    @Override
    public void add(BlockPos altarPos) {
        if (this.altars.isEmpty()) {
            this.altars.add(altarPos);
        } else {
            if (this.altars.contains(altarPos)) {
                return;
            }
            for (int i = 0; i < this.altars.size(); ++i) {
                if (this.pos.distSqr((Vec3i)altarPos) < this.pos.distSqr((Vec3i)this.altars.get(i))) {
                    this.altars.add(i, altarPos);
                    return;
                }
                if (i != this.altars.size() - 1) continue;
                this.altars.add(altarPos);
                return;
            }
        }
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.put("altars", (Tag)BlockPos.CODEC.listOf().encodeStart((DynamicOps)NbtOps.INSTANCE, this.altars).getOrThrow());
        return tag;
    }

    @Override
    public void deserialize(CompoundTag tag) {
        this.altars.clear();
        this.altars.addAll((Collection)BlockPos.CODEC.listOf().parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("altars")).getOrThrow());
    }
}

