/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.altar;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.favouriteless.enchanted.common.init.EData;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public record PowerProvider(int power, int limit) {
    public static final Codec<PowerProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("power").forGetter(data -> data.power), (App)Codec.INT.fieldOf("limit").forGetter(data -> data.limit)).apply((Applicative)instance, PowerProvider::new));

    public static PowerProvider get(Level level, Block block) {
        return PowerProvider.get(block.builtInRegistryHolder().key().location(), (Registry<PowerProvider>)level.registryAccess().registryOrThrow(EData.ALTAR_BLOCK_REGISTRY));
    }

    public static PowerProvider get(Level level, TagKey<Block> tag) {
        return PowerProvider.get(tag.location(), (Registry<PowerProvider>)level.registryAccess().registryOrThrow(EData.ALTAR_TAG_REGISTRY));
    }

    public static PowerProvider get(ResourceLocation id, Registry<PowerProvider> registry) {
        return (PowerProvider)registry.get(id);
    }
}

