/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.altar;

import java.util.HashMap;
import java.util.Map;
import net.favouriteless.enchanted.common.altar.AltarUpgrade;
import net.favouriteless.enchanted.common.init.EData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class AltarUpgradeData {
    private final Map<ResourceLocation, Integer> loadData = new HashMap<ResourceLocation, Integer>();
    private boolean isInitialised = false;
    private final Map<ResourceLocation, Map<AltarUpgrade, Integer>> upgrades = new HashMap<ResourceLocation, Map<AltarUpgrade, Integer>>();

    public boolean addBlock(Level level, Block block) {
        Map type;
        this.tryInitialise(level);
        AltarUpgrade upgrade = AltarUpgrade.get(level, block);
        if (upgrade == null) {
            return false;
        }
        type.put(upgrade, (type = this.upgrades.computeIfAbsent(upgrade.type(), k -> new HashMap())).containsKey(upgrade) ? (Integer)type.get(upgrade) + 1 : 1);
        return true;
    }

    public boolean removeBlock(Level level, Block block) {
        this.tryInitialise(level);
        AltarUpgrade upgrade = AltarUpgrade.get(level, block);
        if (upgrade == null) {
            return false;
        }
        Map<AltarUpgrade, Integer> type = this.upgrades.get(upgrade.type());
        if (type != null && type.containsKey(upgrade)) {
            int count = type.get(upgrade);
            if (count <= 1) {
                type.remove(upgrade);
            } else {
                type.put(upgrade, count - 1);
            }
        }
        return true;
    }

    public double calculatePowerMultiplier(Level level) {
        this.tryInitialise(level);
        double multiplier = 1.0;
        for (ResourceLocation type : this.upgrades.keySet()) {
            AltarUpgrade highest = null;
            for (AltarUpgrade upgrade : this.upgrades.get(type).keySet()) {
                if (highest != null && highest.priority() >= upgrade.priority()) continue;
                highest = upgrade;
            }
            if (highest == null) continue;
            multiplier += highest.power();
        }
        return multiplier;
    }

    public double calculateRechargeMultiplier(Level level) {
        this.tryInitialise(level);
        double multiplier = 1.0;
        for (ResourceLocation type : this.upgrades.keySet()) {
            AltarUpgrade highest = null;
            for (AltarUpgrade upgrade : this.upgrades.get(type).keySet()) {
                if (highest != null && highest.priority() >= upgrade.priority()) continue;
                highest = upgrade;
            }
            if (highest == null) continue;
            multiplier += highest.recharge();
        }
        return multiplier;
    }

    public void reset() {
        this.loadData.clear();
        this.upgrades.clear();
    }

    public CompoundTag save(Level level) {
        CompoundTag nbt = new CompoundTag();
        level.registryAccess().registry(EData.ALTAR_UPGRADE_REGISTRY).ifPresent(registry -> {
            for (Map<AltarUpgrade, Integer> typeMap : this.upgrades.values()) {
                for (Map.Entry<AltarUpgrade, Integer> entry : typeMap.entrySet()) {
                    nbt.putInt(registry.getKey((Object)entry.getKey()).toString(), entry.getValue().intValue());
                }
            }
        });
        return nbt;
    }

    public void load(CompoundTag nbt) {
        for (String key : nbt.getAllKeys()) {
            this.loadData.put(ResourceLocation.parse((String)key), nbt.getInt(key));
        }
        this.isInitialised = false;
    }

    private void tryInitialise(Level level) {
        if (!this.isInitialised) {
            this.upgrades.clear();
            level.registryAccess().registry(EData.ALTAR_UPGRADE_REGISTRY).ifPresent(registry -> {
                for (Map.Entry<ResourceLocation, Integer> entry : this.loadData.entrySet()) {
                    AltarUpgrade upgrade;
                    if (entry.getValue() == 0 || (upgrade = (AltarUpgrade)registry.get(entry.getKey())) == null) continue;
                    ResourceLocation type = upgrade.type();
                    Map typeMap = this.upgrades.computeIfAbsent(type, a -> new HashMap());
                    typeMap.put(upgrade, entry.getValue());
                }
                this.isInitialised = true;
            });
        }
    }
}

