/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.altar;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.favouriteless.enchanted.common.init.EData;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public record AltarUpgrade(ResourceLocation type, Block block, double recharge, double power, int priority) {
    public static final Codec<AltarUpgrade> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("type").forGetter(data -> data.type.toString()), (App)Codec.STRING.fieldOf("block").forGetter(data -> BuiltInRegistries.BLOCK.getKey((Object)data.block).toString()), (App)Codec.DOUBLE.fieldOf("recharge").forGetter(data -> data.recharge), (App)Codec.DOUBLE.fieldOf("power").forGetter(data -> data.power), (App)Codec.INT.fieldOf("priority").forGetter(data -> data.priority)).apply((Applicative)instance, (type, block, recharge, power, priority) -> new AltarUpgrade(ResourceLocation.parse((String)type), (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)block)), (double)recharge, (double)power, (int)priority)));

    public static AltarUpgrade get(Level level, Block block) {
        Optional optional = level.registryAccess().registry(EData.ALTAR_UPGRADE_REGISTRY);
        if (optional.isPresent()) {
            for (AltarUpgrade upgrade : (Registry)optional.get()) {
                if (upgrade.block() != block) continue;
                return upgrade;
            }
        }
        return null;
    }

    public static AltarUpgrade get(Level level, ResourceLocation location) {
        return level.registryAccess().registry(EData.ALTAR_UPGRADE_REGISTRY).map(altarUpgrades -> (AltarUpgrade)altarUpgrades.get(location)).orElse(null);
    }
}

