/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common.altar;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Iterator;
import net.favouriteless.enchanted.common.altar.PowerProvider;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class AltarBlockData {
    private boolean isInitialised = false;
    public Object2IntMap<Block> blockCounts = new Object2IntOpenHashMap();
    public Object2IntMap<TagKey<Block>> tagCounts = new Object2IntOpenHashMap();

    public int addBlock(Level level, Block block) {
        this.tryInitialise(level);
        return this.changePower(level, block, this::changeAdd);
    }

    public int removeBlock(Level level, Block block) {
        this.tryInitialise(level);
        return this.changePower(level, block, this::changeRemove);
    }

    private int changePower(Level level, Block block, ApplyFunction apply) {
        PowerProvider provider = PowerProvider.get(level, block);
        if (provider != null) {
            return apply.apply(this.blockCounts, block, provider);
        }
        Iterator iterator = block.builtInRegistryHolder().tags().iterator();
        while (iterator.hasNext()) {
            TagKey tag = (TagKey)iterator.next();
            provider = PowerProvider.get(level, (TagKey<Block>)tag);
            if (provider == null) continue;
            return apply.apply(this.tagCounts, tag, provider);
        }
        return 0;
    }

    private <T> int changeAdd(Object2IntMap<T> map, T key, PowerProvider provider) {
        return (Integer)map.compute(key, (k, v) -> v != null ? v + 1 : 1) <= provider.limit() ? provider.power() : 0;
    }

    private <T> int changeRemove(Object2IntMap<T> map, T key, PowerProvider provider) {
        int count = (Integer)map.compute(key, (k, v) -> v != null ? v - 1 : 0);
        if (count < 1) {
            map.removeInt(key);
        }
        return count < provider.limit() ? provider.power() : 0;
    }

    public double calculatePower(Level level, double powerMultiplier) {
        PowerProvider provider;
        this.tryInitialise(level);
        double newPower = 0.0;
        for (Block block : this.blockCounts.keySet()) {
            provider = PowerProvider.get(level, block);
            if (provider == null) continue;
            newPower += (double)(Math.max(0, Math.min(provider.limit(), this.blockCounts.getInt((Object)block))) * provider.power()) * powerMultiplier;
        }
        for (TagKey tag : this.tagCounts.keySet()) {
            provider = PowerProvider.get(level, (TagKey<Block>)tag);
            if (provider == null) continue;
            newPower += (double)(Math.max(0, Math.min(provider.limit(), this.tagCounts.getInt((Object)tag))) * provider.power()) * powerMultiplier;
        }
        return newPower;
    }

    public void reset() {
        this.blockCounts.clear();
        this.tagCounts.clear();
    }

    public CompoundTag save() {
        CompoundTag nbt = new CompoundTag();
        CompoundTag blockNbt = new CompoundTag();
        CompoundTag tagNbt = new CompoundTag();
        for (Block block : this.blockCounts.keySet()) {
            blockNbt.putInt(BuiltInRegistries.BLOCK.getKey((Object)block).toString(), this.blockCounts.getInt((Object)block));
        }
        for (TagKey tag : this.tagCounts.keySet()) {
            tagNbt.putInt(tag.location().toString(), this.tagCounts.getInt((Object)tag));
        }
        nbt.put("blockCounts", (Tag)blockNbt);
        nbt.put("tagsCounts", (Tag)tagNbt);
        return nbt;
    }

    public void load(CompoundTag nbt) {
        CompoundTag blockNbt = nbt.getCompound("blockCounts");
        CompoundTag tagNbt = nbt.getCompound("tagsCounts");
        for (String name : blockNbt.getAllKeys()) {
            Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)name));
            if (block == Blocks.AIR) continue;
            this.blockCounts.put((Object)block, blockNbt.getInt(name));
        }
        for (String name : tagNbt.getAllKeys()) {
            this.tagCounts.put((Object)TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)name)), tagNbt.getInt(name));
        }
        this.isInitialised = false;
    }

    private void tryInitialise(Level level) {
        if (this.isInitialised) {
            return;
        }
        for (Block block : this.blockCounts.keySet()) {
            if (PowerProvider.get(level, block) != null) continue;
            this.blockCounts.removeInt((Object)block);
        }
        for (TagKey tag : this.tagCounts.keySet()) {
            if (PowerProvider.get(level, (TagKey<Block>)tag) != null) continue;
            this.tagCounts.removeInt((Object)tag);
        }
        this.isInitialised = true;
    }

    @FunctionalInterface
    public static interface ApplyFunction {
        public <T> int apply(Object2IntMap<T> var1, T var2, PowerProvider var3);
    }
}

