/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common;

import java.util.List;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ServerConfig {
    public static final ServerConfig INSTANCE;
    public static final ModConfigSpec SPEC;
    public final ModConfigSpec.ConfigValue<List<? extends String>> disabledRites;
    public final ModConfigSpec.IntValue altarRange;
    public final ModConfigSpec.DoubleValue altarBaseRecharge;
    public final ModConfigSpec.BooleanValue cauldronItemSpoil;
    public final ModConfigSpec.BooleanValue kettleItemSpoil;
    public final ModConfigSpec.BooleanValue hoeOnlySeeds;
    public final ModConfigSpec.BooleanValue disableTotems;
    public final ModConfigSpec.IntValue curseWhisperMax;
    public final ModConfigSpec.IntValue curseWhisperMin;

    private ServerConfig(ModConfigSpec.Builder builder) {
        builder.push("Circle Magic Options");
        this.disabledRites = builder.comment("Disabled rite types").defineListAllowEmpty("disabled_rites", List::of, () -> "", e -> true);
        builder.pop();
        builder.push("Altar Options");
        this.altarRange = builder.comment("Range of altars").defineInRange("altar_range", 32, 1, Integer.MAX_VALUE);
        this.altarBaseRecharge = builder.comment("Multiplier for altar power recharge rates").defineInRange("altar_recharge_rate", 2.0, 0.0, Double.MAX_VALUE);
        builder.pop();
        builder.push("Cauldron Options");
        this.cauldronItemSpoil = builder.comment("Allow incorrect items to spoil brew").define("cauldron_item_spoil", true);
        builder.pop();
        builder.push("Kettle Options");
        this.kettleItemSpoil = builder.comment("Allow incorrect items to spoil brew").define("kettle_item_spoil", true);
        builder.pop();
        builder.push("Miscellaneous Options");
        this.hoeOnlySeeds = builder.comment("Only drop modded seeds when a hoe is used to break grass.").define("hoe_seeds", false);
        this.disableTotems = builder.comment("Disable totems of undying (to make poppets more useful)").define("disable_totems", false);
        builder.pop();
        builder.push("Curse Options");
        this.curseWhisperMin = builder.comment("The minimum amount of time in seconds between curses whispering at players.").defineInRange("curse_whisper_min", 120, 0, Integer.MAX_VALUE);
        this.curseWhisperMax = builder.comment("The maximum amount of time in seconds between curses whispering at players.").defineInRange("curse_whisper_max", 240, 0, Integer.MAX_VALUE);
        builder.pop();
    }

    static {
        Pair pair = new ModConfigSpec.Builder().configure(ServerConfig::new);
        INSTANCE = (ServerConfig)pair.getLeft();
        SPEC = (ModConfigSpec)pair.getRight();
    }
}

