/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.ServerConfig;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class LootExtensions {
    private static final Map<ResourceLocation, LootExtension> extensions = new HashMap<ResourceLocation, LootExtension>();

    public static void register(ResourceLocation id, LootExtension extension) {
        extensions.put(id, extension);
    }

    public static void tryRoll(LootTable table, LootContext context, Consumer<ItemStack> output) {
        Registry registry = context.getLevel().getServer().reloadableRegistries().get().registryOrThrow(Registries.LOOT_TABLE);
        LootExtension extension = extensions.get(registry.getKey((Object)table));
        if (extension == null) {
            return;
        }
        if (!extension.predicate().test(context)) {
            return;
        }
        LootTable extended = (LootTable)registry.get(extension.table());
        if (extended == null) {
            return;
        }
        extended.getRandomItemsRaw(context, output);
    }

    static {
        LootExtensions.register(ResourceLocation.withDefaultNamespace((String)"blocks/short_grass"), new LootExtension(Enchanted.id("extensions/grass_seeds"), c -> (Boolean)ServerConfig.INSTANCE.hoeOnlySeeds.get() == false || ((ItemStack)c.getParam(LootContextParams.TOOL)).getItem() instanceof HoeItem));
        LootExtensions.register(ResourceLocation.withDefaultNamespace((String)"entities/bat"), new LootExtension(Enchanted.id("extensions/arthana/bat"), c -> true));
        LootExtensions.register(ResourceLocation.withDefaultNamespace((String)"entities/creeper"), new LootExtension(Enchanted.id("extensions/arthana/creeper"), c -> true));
        LootExtensions.register(ResourceLocation.withDefaultNamespace((String)"entities/wolf"), new LootExtension(Enchanted.id("extensions/arthana/wolf"), c -> true));
        LootExtensions.register(ResourceLocation.withDefaultNamespace((String)"entities/skeleton"), new LootExtension(Enchanted.id("extensions/arthana/skeleton"), c -> true));
    }

    public record LootExtension(ResourceLocation table, Predicate<LootContext> predicate) {
    }
}

