/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.common;

import java.util.Random;
import net.favouriteless.enchanted.common.blocks.entity.EBlockEntityTypes;
import net.favouriteless.enchanted.common.init.EBlocks;
import net.favouriteless.enchanted.common.init.ECreativeTab;
import net.favouriteless.enchanted.common.init.EData;
import net.favouriteless.enchanted.common.init.EEntityTypes;
import net.favouriteless.enchanted.common.init.EItems;
import net.favouriteless.enchanted.common.init.EMenuTypes;
import net.favouriteless.enchanted.common.init.EMobEffects;
import net.favouriteless.enchanted.common.init.EPackets;
import net.favouriteless.enchanted.common.init.EParticleTypes;
import net.favouriteless.enchanted.common.init.ERecipeTypes;
import net.favouriteless.enchanted.common.init.ERiteFactories;
import net.favouriteless.enchanted.common.init.ESoundEvents;
import net.favouriteless.enchanted.common.items.component.EDataComponents;
import net.favouriteless.enchanted.common.mutandis.MutagenSavedData;
import net.favouriteless.enchanted.integrations.modopedia.EModopedia;
import net.favouriteless.stateobserver.api.StateObserverManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Enchanted {
    public static final String MOD_ID = "enchanted";
    public static final Logger LOG = LoggerFactory.getLogger((String)"enchanted");
    public static final Random RANDOM = new Random();
    public static final RandomSource RANDOMSOURCE = RandomSource.create();

    public static void init() {
        EPackets.register();
        Enchanted.loadRegistries();
        StateObserverManager.get().registerGlobalListener((level, pos, old, state) -> {
            if (old.getBlock() != state.getBlock() || !state.isRandomlyTicking()) {
                MutagenSavedData.get(level).remove(pos);
            }
        });
    }

    public static void loadRegistries() {
        ESoundEvents.load();
        EDataComponents.load();
        EItems.load();
        EBlocks.load();
        EBlockEntityTypes.load();
        EEntityTypes.load();
        EMobEffects.load();
        EParticleTypes.load();
        EMenuTypes.load();
        ERecipeTypes.load();
        EData.load();
        ECreativeTab.load();
        ERiteFactories.load();
        EModopedia.initCommon();
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static String savedDataName(String suffix) {
        return "enchanted_" + suffix;
    }
}

