/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.client.screens.modopedia;

import java.util.List;
import java.util.Objects;
import net.favouriteless.modopedia.api.book.Book;
import net.favouriteless.modopedia.api.book.BookContent;
import net.favouriteless.modopedia.api.book.BookTexture;
import net.favouriteless.modopedia.api.book.BookType;
import net.favouriteless.modopedia.book.text.Justify;
import net.favouriteless.modopedia.book.text.TextParser;
import net.favouriteless.modopedia.client.screens.books.BookScreen;
import net.favouriteless.modopedia.client.screens.books.ClassicLandingScreen;
import net.favouriteless.modopedia.client.screens.books.book_screen_pages.LandingScreenPage;
import net.favouriteless.modopedia.client.screens.books.book_screen_pages.ScreenPage;
import net.favouriteless.modopedia.common.book_types.LockedViewProvider;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class EClassicLandingScreen<T extends BookType & LockedViewProvider>
extends ClassicLandingScreen<T> {
    public EClassicLandingScreen(Book book, T type, String language, BookContent.LocalisedBookContent content, BookScreen<?> lastScreen) {
        super(book, type, language, content, lastScreen);
    }

    protected ScreenPage initFirstPage() {
        String rawLandingText = this.book.getRawLandingText();
        if (rawLandingText != null) {
            rawLandingText = Language.getInstance().getOrDefault(rawLandingText);
        }
        int lineWidth = ((BookTexture.Rectangle)this.texture.pages().getFirst()).width();
        Objects.requireNonNull(Minecraft.getInstance().font);
        int lineHeight = 9;
        List landingText = TextParser.parse((String)rawLandingText, (Style)this.getStyle(), (int)lineWidth, (int)lineHeight, (String)this.language, (Justify)Justify.LEFT);
        Font font = Minecraft.getInstance().font;
        BookTexture.FixedRectangle r = this.texture.titleBacker();
        MutableComponent title = this.title.copy().withStyle(ChatFormatting.BLACK);
        int titleX = r.width() / 2 - font.width((FormattedText)title) / 2;
        return new LandingScreenPage((BookScreen)this, (Component)title, (Component)Component.empty(), titleX, r.height() / 2 - 4, 10, landingText, 0, 0);
    }
}

