/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.client.screens;

import java.awt.Color;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.menus.WitchOvenMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class WitchOvenScreen
extends AbstractContainerScreen<WitchOvenMenu> {
    private static final ResourceLocation TEXTURE = Enchanted.id("textures/gui/menus/witch_oven.png");
    public static final int COOK_BAR_XPOS = 76;
    public static final int COOK_BAR_YPOS = 16;
    public static final int COOK_BAR_ICON_U = 176;
    public static final int COOK_BAR_ICON_V = 14;
    public static final int COOK_BAR_WIDTH = 24;
    public static final int COOK_BAR_HEIGHT = 17;
    public static final int FLAME_XPOS = 80;
    public static final int FLAME_YPOS = 36;
    public static final int FLAME_ICON_U = 176;
    public static final int FLAME_ICON_V = 12;
    public static final int FLAME_SIZE = 14;

    public WitchOvenScreen(WitchOvenMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    public void render(GuiGraphics gui, int xMouse, int yMouse, float partialTicks) {
        this.renderBackground(gui, xMouse, yMouse, partialTicks);
        super.render(gui, xMouse, yMouse, partialTicks);
        this.renderTooltip(gui, xMouse, yMouse);
    }

    protected void renderBg(GuiGraphics gui, float partialTicks, int x, int y) {
        int edgeSpacingX = (this.width - this.imageWidth) / 2;
        int edgeSpacingY = (this.height - this.imageHeight) / 2;
        gui.blit(TEXTURE, edgeSpacingX, edgeSpacingY, 0, 0, this.imageWidth, this.imageHeight);
        int cookProgressionScaled = this.getCookProgressionScaled();
        gui.blit(TEXTURE, this.leftPos + 76, this.topPos + 16, 176, 14, cookProgressionScaled + 1, 17);
        if (((WitchOvenMenu)this.menu).getBurnDuration() > 0) {
            int burnLeftScaled = this.getBurnLeftScaled();
            gui.blit(TEXTURE, this.leftPos + 80, this.topPos + 36 + 12 - burnLeftScaled, 176, 12 - burnLeftScaled, 14, burnLeftScaled + 1);
        }
    }

    protected void renderLabels(GuiGraphics gui, int xMouse, int yMouse) {
        gui.drawString(this.font, this.title, this.imageWidth / 2 - this.font.width((FormattedText)this.title) / 2, this.titleLabelY, Color.DARK_GRAY.getRGB(), false);
        gui.drawString(this.font, this.minecraft.player.getInventory().getDisplayName(), this.inventoryLabelX, this.inventoryLabelY, Color.DARK_GRAY.getRGB(), false);
    }

    public int getBurnLeftScaled() {
        int burnDuration = ((WitchOvenMenu)this.menu).getBurnDuration();
        int burnProgress = ((WitchOvenMenu)this.menu).getBurnProgress();
        if (burnDuration == 0) {
            burnDuration = 200;
        }
        return burnProgress * 13 / burnDuration;
    }

    public int getCookProgressionScaled() {
        int cookProgress = ((WitchOvenMenu)this.menu).getCookProgress();
        int cookDuration = ((WitchOvenMenu)this.menu).getCookDuration();
        return cookDuration != 0 && cookProgress != 0 ? cookProgress * 24 / cookDuration : 0;
    }
}

