/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.client.screens;

import java.awt.Color;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.menus.SpinningWheelMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class SpinningWheelScreen
extends AbstractContainerScreen<SpinningWheelMenu> {
    private static final ResourceLocation TEXTURE = Enchanted.id("textures/gui/menus/spinning_wheel.png");
    public static final int ICONS_U = 176;
    public static final int BAR0_XPOS = 27;
    public static final int BAR1_XPOS = 64;
    public static final int BAR_YPOS = 25;
    public static final int BAR0_ICON_V = 0;
    public static final int BAR1_ICON_V = 20;
    public static final int BAR_HEIGHT = 20;
    public static final int BAR_WIDTH = 15;
    public static final int WHEEL_XPOS = 86;
    public static final int WHEEL_YPOS = 25;
    public static final int WHEEL_FRAME1_V = 40;
    public static final int WHEEL_FRAME2_V = 74;
    public static final int WHEEL_SIZE = 34;

    public SpinningWheelScreen(SpinningWheelMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    public void render(GuiGraphics gui, int xMouse, int yMouse, float partialTicks) {
        this.renderBackground(gui, xMouse, yMouse, partialTicks);
        super.render(gui, xMouse, yMouse, partialTicks);
        this.renderTooltip(gui, xMouse, yMouse);
    }

    protected void renderBg(GuiGraphics gui, float partialTicks, int x, int y) {
        int edgeSpacingX = (this.width - this.imageWidth) / 2;
        int edgeSpacingY = (this.height - this.imageHeight) / 2;
        gui.blit(TEXTURE, edgeSpacingX, edgeSpacingY, 0, 0, this.imageWidth, this.imageHeight);
        double progression = (double)((SpinningWheelMenu)this.menu).getSpinProgress() / (double)((SpinningWheelMenu)this.menu).getSpinDuration();
        int barSize = (int)Math.round(20.0 * Math.min(progression * 10.0, 1.0));
        if (((SpinningWheelMenu)this.menu).getSlot(1).hasItem()) {
            gui.blit(TEXTURE, this.leftPos + 27, this.topPos + 25 + 20 - barSize, 176, 20 - barSize, 15, barSize);
        }
        if (((SpinningWheelMenu)this.menu).getSlot(2).hasItem()) {
            gui.blit(TEXTURE, this.leftPos + 64, this.topPos + 25 + 20 - barSize, 176, 40 - barSize, 15, barSize);
        }
        if (progression > 0.1) {
            int frame = (int)Math.round((progression - 0.1) * 200.0) % 3;
            if (frame == 0) {
                gui.blit(TEXTURE, this.leftPos + 86, this.topPos + 25, 176, 74, 34, 34);
            } else if (frame == 2) {
                gui.blit(TEXTURE, this.leftPos + 86, this.topPos + 25, 176, 40, 34, 34);
            }
        }
    }

    protected void renderLabels(GuiGraphics gui, int xMouse, int yMouse) {
        gui.drawString(this.font, this.title, this.imageWidth / 2 - this.font.width((FormattedText)this.title) / 2, this.titleLabelY, Color.DARK_GRAY.getRGB(), false);
        gui.drawString(this.font, this.minecraft.player.getInventory().getDisplayName(), this.inventoryLabelX, this.inventoryLabelY, Color.DARK_GRAY.getRGB(), false);
    }
}

