/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.client.screens;

import java.awt.Color;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.menus.DistilleryMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public class DistilleryScreen
extends AbstractContainerScreen<DistilleryMenu> {
    private static final ResourceLocation TEXTURE = Enchanted.id("textures/gui/menus/distillery.png");
    public static final int COOK_BAR_XPOS = 69;
    public static final int COOK_BAR_YPOS = 12;
    public static final int COOK_BAR_ICON_U = 176;
    public static final int COOK_BAR_ICON_V = 29;
    public static final int COOK_BAR_WIDTH = 56;
    public static final int COOK_BAR_HEIGHT = 62;
    public static final int BUBBLES_XPOS = 93;
    public static final int BUBBLES_YPOS = 56;
    public static final int BUBBLES_ICON_U = 176;
    public static final int BUBBLES_ICON_V = 28;
    private static final int[] BUBBLELENGTHS = new int[]{0, 6, 11, 16, 20, 24, 29};

    public DistilleryScreen(DistilleryMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    public void render(@NotNull GuiGraphics gui, int xMouse, int yMouse, float partialTicks) {
        this.renderBackground(gui, xMouse, yMouse, partialTicks);
        super.render(gui, xMouse, yMouse, partialTicks);
        this.renderTooltip(gui, xMouse, yMouse);
    }

    protected void renderBg(@NotNull GuiGraphics gui, float partialTicks, int x, int y) {
        int edgeSpacingX = (this.width - this.imageWidth) / 2;
        int edgeSpacingY = (this.height - this.imageHeight) / 2;
        gui.blit(TEXTURE, edgeSpacingX, edgeSpacingY, 0, 0, this.imageWidth, this.imageHeight);
        int cookProgress = ((DistilleryMenu)this.menu).getCookProgress();
        int cookDuration = ((DistilleryMenu)this.menu).getCookDuration();
        int cookProgressionScaled = cookDuration != 0 && cookProgress != 0 ? cookProgress * 56 / cookDuration : 0;
        gui.blit(TEXTURE, this.leftPos + 69, this.topPos + 12, 176, 29, cookProgressionScaled + 1, 62);
        int bubbleOffset = BUBBLELENGTHS[cookProgress / 2 % 7];
        if (bubbleOffset > 0) {
            gui.blit(TEXTURE, this.leftPos + 93, this.topPos + 56 - bubbleOffset, 176, 28 - bubbleOffset, 12, bubbleOffset);
        }
    }

    protected void renderLabels(@NotNull GuiGraphics gui, int xMouse, int yMouse) {
        gui.drawString(this.font, this.title, this.imageWidth / 2 - this.font.width((FormattedText)this.title) / 2, this.titleLabelY, Color.DARK_GRAY.getRGB(), false);
        gui.drawString(this.font, this.minecraft.player.getInventory().getDisplayName(), this.inventoryLabelX, this.inventoryLabelY, Color.DARK_GRAY.getRGB(), false);
    }
}

