/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.Objects;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.menus.AltarMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class AltarScreen
extends AbstractContainerScreen<AltarMenu> {
    private static final ResourceLocation TEXTURE = Enchanted.id("textures/gui/menus/altar.png");

    public AltarScreen(AltarMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 176;
        this.imageHeight = 88;
    }

    protected void renderBg(GuiGraphics gui, float xMouse, int yMouse, int partialTicks) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int edgeSpacingX = (this.width - this.imageWidth) / 2;
        int edgeSpacingY = (this.height - this.imageHeight) / 2;
        gui.blit(TEXTURE, edgeSpacingX, edgeSpacingY, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void render(GuiGraphics gui, int xMouse, int yMouse, float partialTicks) {
        this.renderBackground(gui, xMouse, yMouse, partialTicks);
        super.render(gui, xMouse, yMouse, partialTicks);
    }

    protected void renderLabels(GuiGraphics gui, int x, int y) {
        String powerString = String.format("%s/%s (%sx)", ((AltarMenu)this.menu).getCurrentPower(), ((AltarMenu)this.menu).getMaxPower(), ((AltarMenu)this.menu).getRechargeMultiplier());
        int xOffset = this.font.width(powerString) / 2;
        Objects.requireNonNull(this.font);
        int yOffset = 9 / 2;
        gui.drawString(this.font, powerString, this.imageWidth / 2 - xOffset, this.imageHeight / 2 - yOffset, Color.darkGray.getRGB(), false);
    }
}

