/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.client.render.poppet;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.favouriteless.enchanted.common.Enchanted;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class PoppetAnimation {
    private final ItemStack itemStack;
    protected int ticks;

    public PoppetAnimation(ItemStack itemStack, int ticks) {
        this.itemStack = itemStack;
        this.ticks = ticks;
    }

    public void render(PoseStack poseStack, float partialTicks, int widthScaled, int heightScaled) {
        int ticksLeft = 120 - this.ticks;
        float work = ((float)ticksLeft + partialTicks) / 120.0f;
        float workSq = work * work;
        float workCb = workSq * work;
        float scale = 255.0f * Mth.sin((float)((float)Math.pow(2.05f * work - 0.9f, 7.0) + 0.5f));
        poseStack.pushPose();
        Minecraft minecraft = Minecraft.getInstance();
        if (work > 0.2f && work < 0.55f) {
            int maxOffset = widthScaled > heightScaled ? widthScaled / 80 : heightScaled / 80;
            int offsetOffset = maxOffset / 2;
            poseStack.translate((float)(Enchanted.RANDOM.nextInt(maxOffset) - offsetOffset), (float)(Enchanted.RANDOM.nextInt(maxOffset) - offsetOffset), 0.0f);
        }
        poseStack.translate((double)((float)widthScaled / 2.0f), (double)((float)heightScaled / 2.0f), -50.0);
        poseStack.scale(scale, -scale, scale);
        float rotationCurve = 10.25f * workCb * workSq - 24.95f * workSq * workSq + 25.5f * workSq * work - 13.8f * workSq + 4.0f * work;
        float piCurve = rotationCurve * (float)Math.PI;
        poseStack.mulPose(Axis.YP.rotationDegrees(900.0f * Mth.abs((float)Mth.sin((float)piCurve))));
        poseStack.mulPose(Axis.XP.rotationDegrees(6.0f * Mth.cos((float)(work * 8.0f))));
        poseStack.mulPose(Axis.ZP.rotationDegrees(6.0f * Mth.cos((float)(work * 8.0f))));
        MultiBufferSource.BufferSource renderTypeBuffer = Minecraft.getInstance().renderBuffers().bufferSource();
        minecraft.getItemRenderer().renderStatic(this.itemStack, ItemDisplayContext.FIXED, 0xF000F0, OverlayTexture.NO_OVERLAY, poseStack, (MultiBufferSource)renderTypeBuffer, (Level)minecraft.level, 0);
        poseStack.popPose();
        renderTypeBuffer.endBatch();
    }

    public ItemStack getItem() {
        return this.itemStack;
    }

    public int getTicks() {
        return this.ticks;
    }

    public void tick() {
        --this.ticks;
    }
}

