/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.favouriteless.enchanted.client.ClientConfig;
import net.favouriteless.enchanted.common.entities.FamiliarCat;
import net.minecraft.client.model.CatModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;

public class FamiliarCatRenderer
extends MobRenderer<FamiliarCat, CatModel<FamiliarCat>> {
    public static final ResourceLocation TEXTURE_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/cat/all_black.png");

    public FamiliarCatRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new CatModel(context.bakeLayer(ModelLayers.CAT)), 0.4f);
    }

    public ResourceLocation getTextureLocation(FamiliarCat cat) {
        return (Boolean)ClientConfig.INSTANCE.useOriginalCatType.get() != false ? cat.getTextureId() : TEXTURE_LOCATION;
    }

    protected void scale(FamiliarCat cat, PoseStack poseStack, float partialTicks) {
        super.scale((LivingEntity)cat, poseStack, partialTicks);
        poseStack.scale(0.8f, 0.8f, 0.8f);
    }

    protected void setupRotations(FamiliarCat cat, PoseStack poseStack, float age, float yaw, float partialTicks, float scale) {
        super.setupRotations((LivingEntity)cat, poseStack, age, yaw, partialTicks, scale);
        float f = cat.getLieDownAmount(partialTicks);
        if (f > 0.0f) {
            poseStack.translate(0.4f * f, 0.15f * f, 0.1f * f);
            poseStack.mulPose(Axis.ZP.rotationDegrees(Mth.rotLerp((float)f, (float)0.0f, (float)90.0f)));
            BlockPos blockpos = cat.blockPosition();
            for (Player player : cat.level().getEntitiesOfClass(Player.class, new AABB(blockpos).inflate(2.0, 2.0, 2.0))) {
                if (!player.isSleeping()) continue;
                poseStack.translate((double)(0.15f * f), 0.0, 0.0);
                break;
            }
        }
    }
}

