/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.favouriteless.enchanted.client.render.model.ModelLayerLocations;
import net.favouriteless.enchanted.client.render.model.entity.BroomstickModel;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.entities.Broomstick;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class BroomstickRenderer
extends EntityRenderer<Broomstick> {
    public static final ResourceLocation TEXTURE = Enchanted.id("textures/entity/broomstick.png");
    protected final BroomstickModel model;

    public BroomstickRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new BroomstickModel(context.bakeLayer(ModelLayerLocations.BROOMSTICK));
    }

    public void render(Broomstick broomstick, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        poseStack.translate(0.0, 0.7, 0.0);
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f - Mth.lerp((float)partialTicks, (float)broomstick.xRotO, (float)broomstick.getXRot())));
        float f = (float)broomstick.getHurtTime() - partialTicks;
        float f1 = broomstick.getDamage() - partialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            poseStack.mulPose(Axis.XP.rotationDegrees(Mth.sin((float)f) * f * f1 / 10.0f * (float)broomstick.getHurtDir()));
        }
        VertexConsumer buffer = bufferSource.getBuffer(this.model.renderType(this.getTextureLocation(broomstick)));
        this.model.renderToBuffer(poseStack, buffer, packedLight, OverlayTexture.NO_OVERLAY, -1);
        poseStack.popPose();
        super.render((Entity)broomstick, yaw, partialTicks, poseStack, bufferSource, packedLight);
    }

    public ResourceLocation getTextureLocation(Broomstick entity) {
        return TEXTURE;
    }
}

