/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.favouriteless.enchanted.client.render.model.ModelLayerLocations;
import net.favouriteless.enchanted.common.Enchanted;
import net.favouriteless.enchanted.common.blocks.SpinningWheelBlock;
import net.favouriteless.enchanted.common.blocks.entity.SpinningWheelBlockEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;

public class SpinningWheelRenderer
implements BlockEntityRenderer<SpinningWheelBlockEntity> {
    public static final ResourceLocation TEXTURE = Enchanted.id("textures/block/spinning_wheel.png");
    private final ModelPart wheel;
    private final ModelPart body;
    private final ModelPart frontArm;

    public SpinningWheelRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(ModelLayerLocations.SPINNING_WHEEL);
        this.wheel = root.getChild("wheel");
        this.body = root.getChild("body");
        this.frontArm = root.getChild("frontArm");
    }

    public static LayerDefinition createLayerDefinition() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("wheel", CubeListBuilder.create().texOffs(0, 14).addBox(-2.0f, 2.0f, -0.5f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 6).addBox(-3.0f, -2.0f, -0.5f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 12).addBox(-3.0f, -3.0f, -0.5f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(4, 6).addBox(2.0f, -3.0f, -0.5f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(16, 28).addBox(0.0f, -2.0f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(18, 28).addBox(-1.0f, 0.0f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(16, 31).addBox(-2.0f, -1.0f, 0.0f, 2.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(16, 30).addBox(0.0f, 0.0f, 0.0f, 2.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.1f, (float)14.2f, (float)0.0f));
        PartDefinition Body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.396f, (float)18.7149f, (float)0.0f));
        Body.addOrReplaceChild("base2", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, -0.5f, -2.5f, 4.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.4579f, (float)-0.0037f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f));
        Body.addOrReplaceChild("base1", CubeListBuilder.create().texOffs(0, 6).addBox(-2.5f, -0.5f, -1.5f, 6.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.3718f, (float)-1.2978f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f));
        Body.addOrReplaceChild("legS", CubeListBuilder.create().texOffs(28, 26).addBox(-0.5f, -2.5f, -0.5f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(24, 26).addBox(-0.5f, -2.5f, -3.5f, 1.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.9606f, (float)2.9883f, (float)1.5f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        Body.addOrReplaceChild("legE", CubeListBuilder.create().texOffs(20, 16).addBox(-0.5f, -3.5f, -0.5f, 1.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.9391f, (float)1.8151f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1309f));
        Body.addOrReplaceChild("armS", CubeListBuilder.create().texOffs(24, 16).addBox(-0.5f, -4.8f, -0.5f, 1.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(28, 16).addBox(-0.5f, -4.8f, 1.5f, 1.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-0.5f, -4.8f, 0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.354f, (float)-0.7149f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.5672f));
        partdefinition.addOrReplaceChild("frontArm", CubeListBuilder.create().texOffs(20, 28).addBox(-0.5f, -2.75f, -0.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 27).addBox(-1.0f, -4.5f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.8123f, (float)16.6753f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void render(SpinningWheelBlockEntity wheel, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        poseStack.pushPose();
        float rotationYDegrees = wheel.getLevel() != null ? ((Direction)wheel.getBlockState().getValue((Property)SpinningWheelBlock.FACING)).getOpposite().toYRot() : 0.0f;
        poseStack.translate(0.5f, 1.5f, 0.5f);
        poseStack.mulPose(Axis.YN.rotationDegrees(rotationYDegrees));
        poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        float spinProgress = wheel.isSpinning() ? (float)wheel.getSpinProgress() + partialTicks : 0.0f;
        float turnFactor = 25.0f;
        float rotationDegreesWheel = spinProgress % turnFactor * 360.0f / turnFactor;
        float rotationDegreesArm = rotationDegreesWheel * 2.0f;
        VertexConsumer buffer = bufferSource.getBuffer(RenderType.entityTranslucentCull((ResourceLocation)TEXTURE));
        this.body.render(poseStack, buffer, packedLight, packedOverlay);
        this.wheel.zRot = (float)(Math.PI + Math.toRadians(rotationDegreesWheel));
        this.wheel.render(poseStack, buffer, packedLight, packedOverlay);
        this.frontArm.yRot = (float)(Math.PI + Math.toRadians(rotationDegreesArm));
        this.frontArm.render(poseStack, buffer, packedLight, packedOverlay);
        poseStack.popPose();
    }
}

