/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.favouriteless.enchanted.common.blocks.cauldrons.CauldronBlockBase;
import net.favouriteless.enchanted.common.blocks.entity.CauldronBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix4f;

public class CauldronWaterRenderer<T extends CauldronBlockEntity<?>>
implements BlockEntityRenderer<T> {
    public static final ResourceLocation WATER_TEXTURE = ResourceLocation.withDefaultNamespace((String)"block/water_still");
    private final float apothem;

    public CauldronWaterRenderer(float width) {
        this.apothem = width / 32.0f;
    }

    public void render(T be, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        BlockState state = be.getLevel().getBlockState(be.getBlockPos());
        if (state.getBlock() instanceof CauldronBlockBase && ((CauldronBlockEntity)be).getWater() > 0) {
            VertexConsumer buffer = bufferSource.getBuffer(RenderType.translucent());
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(WATER_TEXTURE);
            long time = System.currentTimeMillis() - ((CauldronBlockEntity)be).startTime;
            int r = ((CauldronBlockEntity)be).getRed(time);
            int g = ((CauldronBlockEntity)be).getGreen(time);
            int b = ((CauldronBlockEntity)be).getBlue(time);
            int a = 160;
            poseStack.pushPose();
            poseStack.translate(0.5, ((CauldronBlockEntity)be).getWaterY(state), 0.5);
            Matrix4f p = poseStack.last().pose();
            this.vertex(buffer, p, this.apothem, 0.0f, -this.apothem, r, g, b, a, sprite.getU(0.5f + this.apothem), sprite.getV(0.5f - this.apothem), packedLight);
            this.vertex(buffer, p, -this.apothem, 0.0f, -this.apothem, r, g, b, a, sprite.getU(0.5f - this.apothem), sprite.getV(0.5f - this.apothem), packedLight);
            this.vertex(buffer, p, -this.apothem, 0.0f, this.apothem, r, g, b, a, sprite.getU(0.5f - this.apothem), sprite.getV(0.5f + this.apothem), packedLight);
            this.vertex(buffer, p, this.apothem, 0.0f, this.apothem, r, g, b, a, sprite.getU(0.5f + this.apothem), sprite.getV(0.5f + this.apothem), packedLight);
            poseStack.popPose();
        }
    }

    private void vertex(VertexConsumer consumer, Matrix4f poseMatrix, float x, float y, float z, int red, int green, int blue, int alpha, float u, float v, int packedLight) {
        consumer.addVertex(poseMatrix, x, y, z).setColor(red, green, blue, alpha).setUv(u, v).setLight(packedLight).setNormal(0.0f, 1.0f, 0.0f);
    }
}

