/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.client.particles.types;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.FastColor;

public class TwoColourOptions
implements ParticleOptions {
    private final ParticleType<TwoColourOptions> particleType;
    private final int first;
    private final int second;

    public TwoColourOptions(ParticleType<TwoColourOptions> particleType, int first, int second) {
        this.particleType = particleType;
        this.first = first;
        this.second = first;
    }

    public static MapCodec<TwoColourOptions> codec(ParticleType<TwoColourOptions> type) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("first").forGetter(data -> data.first), (App)Codec.INT.fieldOf("second").forGetter(data -> data.second)).apply((Applicative)instance, (first, second) -> new TwoColourOptions(type, (int)first, (int)second)));
    }

    public static StreamCodec<? super RegistryFriendlyByteBuf, TwoColourOptions> streamCodec(ParticleType<TwoColourOptions> type) {
        return StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, data -> data.first, (StreamCodec)ByteBufCodecs.INT, data -> data.second, (first, second) -> new TwoColourOptions(type, (int)first, (int)second));
    }

    public float getRedFirst() {
        return (float)FastColor.ARGB32.red((int)this.first) / 255.0f;
    }

    public float getGreenFirst() {
        return (float)FastColor.ARGB32.green((int)this.first) / 255.0f;
    }

    public float getBlueFirst() {
        return (float)FastColor.ARGB32.blue((int)this.first) / 255.0f;
    }

    public float getAlphaFirst() {
        return (float)FastColor.ARGB32.alpha((int)this.first) / 255.0f;
    }

    public float getRedSecond() {
        return (float)FastColor.ARGB32.red((int)this.second) / 255.0f;
    }

    public float getGreenSecond() {
        return (float)FastColor.ARGB32.green((int)this.second) / 255.0f;
    }

    public float getBlueSecond() {
        return (float)FastColor.ARGB32.blue((int)this.second) / 255.0f;
    }

    public float getAlphaSecond() {
        return (float)FastColor.ARGB32.alpha((int)this.second) / 255.0f;
    }

    public ParticleType<?> getType() {
        return this.particleType;
    }
}

