/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.enchanted.client.particles.types;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.favouriteless.enchanted.common.util.EExtraCodecs;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.phys.Vec3;

public class DelayedPosOptions
implements ParticleOptions {
    private final ParticleType<DelayedPosOptions> particleType;
    private final Vec3 center;
    private final int delay;

    public DelayedPosOptions(ParticleType<DelayedPosOptions> particleType, Vec3 center, int delay) {
        this.particleType = particleType;
        this.center = center;
        this.delay = delay;
    }

    public static MapCodec<DelayedPosOptions> codec(ParticleType<DelayedPosOptions> type) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)EExtraCodecs.VEC3.fieldOf("center").forGetter(data -> data.center), (App)Codec.INT.fieldOf("delay").forGetter(data -> data.delay)).apply((Applicative)instance, (center, delay) -> new DelayedPosOptions(type, (Vec3)center, (int)delay)));
    }

    public static StreamCodec<? super RegistryFriendlyByteBuf, DelayedPosOptions> streamCodec(ParticleType<DelayedPosOptions> type) {
        return StreamCodec.composite(EExtraCodecs.STREAM_VEC3, data -> data.center, (StreamCodec)ByteBufCodecs.INT, data -> data.delay, (center, delay) -> new DelayedPosOptions(type, (Vec3)center, (int)delay));
    }

    public Vec3 getCenter() {
        return this.center;
    }

    public int getDelay() {
        return this.delay;
    }

    public ParticleType<?> getType() {
        return this.particleType;
    }
}

